/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.jline.terminal.Terminal;
import org.springframework.shell.command.CommandParser;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.util.ObjectUtils;

public interface CommandContext {
    public String[] getRawArgs();

    public boolean hasMappedOption(String var1);

    public CommandParser.CommandParserResults getParserResults();

    public CommandRegistration getCommandRegistration();

    public <T> T getOptionValue(String var1);

    public Terminal getTerminal();

    public static CommandContext of(String[] args, CommandParser.CommandParserResults results, Terminal terminal, CommandRegistration commandRegistration) {
        return new DefaultCommandContext(args, results, terminal, commandRegistration);
    }

    public static class DefaultCommandContext
    implements CommandContext {
        private final String[] args;
        private final CommandParser.CommandParserResults results;
        private final Terminal terminal;
        private final CommandRegistration commandRegistration;

        DefaultCommandContext(String[] args, CommandParser.CommandParserResults results, Terminal terminal, CommandRegistration commandRegistration) {
            this.args = args;
            this.results = results;
            this.terminal = terminal;
            this.commandRegistration = commandRegistration;
        }

        @Override
        public String[] getRawArgs() {
            return this.args;
        }

        @Override
        public boolean hasMappedOption(String name) {
            return this.find(name).isPresent();
        }

        @Override
        public CommandParser.CommandParserResults getParserResults() {
            return this.results;
        }

        @Override
        public CommandRegistration getCommandRegistration() {
            return this.commandRegistration;
        }

        @Override
        public <T> T getOptionValue(String name) {
            Optional<CommandParser.CommandParserResult> find = this.find(name);
            if (find.isPresent()) {
                return (T)find.get().value();
            }
            return null;
        }

        @Override
        public Terminal getTerminal() {
            return this.terminal;
        }

        private Optional<CommandParser.CommandParserResult> find(String name) {
            return this.results.results().stream().filter(r -> {
                Stream l = Arrays.asList(r.option().getLongNames()).stream();
                Stream<String> s = Arrays.asList(r.option().getShortNames()).stream().map(n -> Character.toString(n.charValue()));
                return Stream.concat(l, s).filter(o -> ObjectUtils.nullSafeEquals((Object)o, (Object)name)).findFirst().isPresent();
            }).findFirst();
        }
    }
}

