/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.shell.support.AbstractArgumentMethodArgumentResolver;
import org.springframework.util.Assert;

public class ArgumentHeaderMethodArgumentResolver
extends AbstractArgumentMethodArgumentResolver {
    public ArgumentHeaderMethodArgumentResolver(ConversionService conversionService, @Nullable ConfigurableBeanFactory beanFactory) {
        super(conversionService, beanFactory);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Header.class);
    }

    @Override
    protected AbstractArgumentMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        Header annot = (Header)parameter.getParameterAnnotation(Header.class);
        Assert.state((annot != null ? 1 : 0) != 0, (String)"No Header annotation");
        return new HeaderNamedValueInfo(annot);
    }

    @Override
    @Nullable
    protected Object resolveArgumentInternal(MethodParameter parameter, Message<?> message, List<String> names) throws Exception {
        if (names.size() == 1) {
            return message.getHeaders().get((Object)("springShellArgument." + names.get(0)));
        }
        return null;
    }

    @Override
    protected void handleMissingValue(List<String> headerName, MethodParameter parameter, Message<?> message) {
        throw new MessageHandlingException(message, "Missing header '" + headerName + "' for method parameter type [" + parameter.getParameterType() + "]");
    }

    private static final class HeaderNamedValueInfo
    extends AbstractArgumentMethodArgumentResolver.NamedValueInfo {
        private HeaderNamedValueInfo(Header annotation) {
            super(Arrays.asList(annotation.name()), annotation.required(), annotation.defaultValue());
        }
    }
}

