/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.databasewriter.support;

import com.xebialabs.xlrelease.databasewriter.repository.ArchiveRepository;
import com.xebialabs.xlrelease.databasewriter.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.databasewriter.repository.ReleaseRepository;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00014qa\u0003\u0007\u0011\u0002\u0007\u0005q\u0003C\u0003'\u0001\u0011\u0005q\u0005C\u0003,\u0001\u0019\u0005A\u0006C\u00034\u0001\u0019\u0005A\u0007C\u00039\u0001\u0019\u0005\u0011\b\u0003\u0005>\u0001!\u0015\r\u0011\"\u0003?\u0011\u0015\u0019\u0006\u0001\"\u0001?\u0011\u0015!\u0006\u0001\"\u0003V\u0011\u00151\u0006\u0001\"\u0003X\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015y\u0006\u0001\"\u0003\\\u0005U)6/\u001a:oC6,7oQ1dQ\u0016\u001cV\u000f\u001d9peRT!!\u0004\b\u0002\u000fM,\b\u000f]8si*\u0011q\u0002E\u0001\u000fI\u0006$\u0018MY1tK^\u0014\u0018\u000e^3s\u0015\t\t\"#A\u0005yYJ,G.Z1tK*\u00111\u0003F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!F\u0001\u0004G>l7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f\u001c45U*\t1%\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\r\u0011Jg.\u001b;%)\u0005A\u0003CA\r*\u0013\tQ#D\u0001\u0003V]&$\u0018!E2p]\u001aLw-\u001e:bi&|gNU3q_V\tQ\u0006\u0005\u0002/c5\tqF\u0003\u00021\u001d\u0005Q!/\u001a9pg&$xN]=\n\u0005Iz#aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003-\t'o\u00195jm\u0016\u0014V\r]8\u0016\u0003U\u0002\"A\f\u001c\n\u0005]z#!E!sG\"Lg/\u001a*fa>\u001c\u0018\u000e^8ss\u0006Y!/\u001a7fCN,'+\u001a9p+\u0005Q\u0004C\u0001\u0018<\u0013\tatFA\tSK2,\u0017m]3SKB|7/\u001b;pef\f\u0001\"\u00197m\u001d\u0006lWm]\u000b\u0002\u007fA\u0019\u0001iQ#\u000e\u0003\u0005S!A\u0011\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003\t\u0006\u00131\u0001\u0016:z!\r1U\n\u0015\b\u0003\u000f.\u0003\"\u0001\u0013\u000e\u000e\u0003%S!A\u0013\f\u0002\rq\u0012xn\u001c;?\u0013\ta%$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u00131aU3u\u0015\ta%\u0004\u0005\u0002G#&\u0011!k\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\u001d,G/\u00117m\u001d\u0006lWm]\u0001\u0018M&tG-\u00117m+N,'/\u00118e\rVdGNT1nKN$\u0012aP\u0001\fM&dG/\u001a:OC6,7\u000f\u0006\u0002F1\")\u0011\f\u0003a\u0001\u000b\u0006)a.Y7fg\u0006\u00112\r[3dW&\u001b\u0018I]2iSZLgn\u001a#c)\u0005a\u0006CA\r^\u0013\tq&DA\u0004C_>dW-\u00198\u0002\u001f\rDWmY6Jg\u0006\u001bG/\u001b<f\t\n\u0004")
public interface UsernamesCacheSupport
extends Logging {
    public ConfigurationRepository configurationRepo();

    public ArchiveRepository archiveRepo();

    public ReleaseRepository releaseRepo();

    public static /* synthetic */ Try com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames$(UsernamesCacheSupport $this) {
        return $this.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames();
    }

    default public Try<Set<String>> com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames() {
        return this.findAllUserAndFullNames();
    }

    public static /* synthetic */ Try getAllNames$(UsernamesCacheSupport $this) {
        return $this.getAllNames();
    }

    default public Try<Set<String>> getAllNames() {
        return this.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames();
    }

    private Try<Set<String>> findAllUserAndFullNames() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq seq;
            if (this.checkIsArchivingDb()) {
                this.logger().info((Function0 & Serializable)() -> "querying all usernames from the archive database");
                seq = (Seq)this.archiveRepo().findAllUsernames().get();
            } else if (this.checkIsActiveDb()) {
                this.logger().info((Function0 & Serializable)() -> "querying all usernames and full names from the active database");
                Seq usernames = (Seq)this.configurationRepo().findAllUsernames().get();
                Seq fullNames = (Seq)this.configurationRepo().findAllFullNames().get();
                Seq firstAndLastNames = (Seq)fullNames.flatMap((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])x$1.split("\\s")));
                seq = (Seq)usernames.$plus$plus((IterableOnce)firstAndLastNames);
            } else {
                throw new IllegalStateException("cannot connect to neither archive nor active DB, see the messages above");
            }
            Seq names = seq;
            Set<String> filtered = this.filterNames((Set<String>)names.toSet());
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(39).append("found ").append(filtered.size()).append(" usernames (and maybe full names)").toString());
            return filtered;
        });
    }

    private Set<String> filterNames(Set<String> names) {
        return (Set)((IterableOps)((IterableOps)((IterableOps)names.filterNot((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)UsernamesCacheSupport.$anonfun$filterNames$1(n)))).filterNot((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)UsernamesCacheSupport.$anonfun$filterNames$2(n)))).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UsernamesCacheSupport.$anonfun$filterNames$3(x$2)))).filterNot((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UsernamesCacheSupport.$anonfun$filterNames$4(s)));
    }

    private boolean checkIsArchivingDb() {
        boolean bl;
        Try<Object> try_ = this.archiveRepo().countReleases();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(40).append("Connected to archiving DB with ").append(count).append(" releases").toString());
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(31).append("Not connected to archiving DB: ").append(e.getMessage()).toString());
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private boolean checkIsActiveDb() {
        boolean bl;
        Try<Object> try_ = this.releaseRepo().countReleases();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(37).append("Connected to active DB with ").append(count).append(" releases").toString());
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(28).append("Not connected to active DB: ").append(e.getMessage()).toString());
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$filterNames$1(String n) {
        return n.startsWith("${") && n.endsWith("}");
    }

    public static /* synthetic */ boolean $anonfun$filterNames$2(String n) {
        return n == null || n.isEmpty() || n.equalsIgnoreCase("null");
    }

    public static /* synthetic */ boolean $anonfun$filterNames$3(String x$2) {
        return x$2.length() <= 2;
    }

    public static /* synthetic */ boolean $anonfun$filterNames$4(String s) {
        return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"xlrelease", "xldeploy"})).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(s)));
    }

    public static void $init$(UsernamesCacheSupport $this) {
    }
}

