/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.jline.utils.AttributedString;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.core.io.Resource;
import org.springframework.shell.standard.AbstractShellComponent;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.style.TemplateExecutor;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

@ShellComponent
public class Version
extends AbstractShellComponent {
    private BuildProperties buildProperties;
    private GitProperties gitProperties;
    private TemplateExecutor templateExecutor;
    private String template;
    private boolean showBuildGroup;
    private boolean showBuildArtifact;
    private boolean showBuildName;
    private boolean showBuildVersion;
    private boolean showBuildTime;
    private boolean showGitBranch;
    private boolean showGitCommitId;
    private boolean showGitShortCommitId;
    private boolean showGitCommitTime;

    public Version(TemplateExecutor templateExecutor) {
        this.templateExecutor = templateExecutor;
    }

    @ShellMethod(key={"version"}, value="Show version info")
    public AttributedString version() {
        String templateResource = Version.resourceAsString(this.getResourceLoader().getResource(this.template));
        HashMap<String, String> attributes = new HashMap<String, String>();
        String buildGroup = null;
        String buildArtifact = null;
        String buildName = null;
        String buildVersion = null;
        String buildTime = null;
        String gitBranch = null;
        String gitCommitId = null;
        String gitShortCommitId = null;
        String gitCommitTime = null;
        if (this.buildProperties != null) {
            if (this.showBuildGroup && StringUtils.hasText((String)this.buildProperties.getGroup())) {
                buildGroup = this.buildProperties.getGroup();
            }
            if (this.showBuildArtifact && StringUtils.hasText((String)this.buildProperties.getArtifact())) {
                buildArtifact = this.buildProperties.getArtifact();
            }
            if (this.showBuildName && StringUtils.hasText((String)this.buildProperties.getName())) {
                buildName = this.buildProperties.getName();
            }
            if (this.showBuildVersion && StringUtils.hasText((String)this.buildProperties.getVersion())) {
                buildVersion = this.buildProperties.getVersion();
            }
            if (this.showBuildTime && this.buildProperties.getTime() != null) {
                buildTime = this.buildProperties.getTime().toString();
            }
        }
        if (this.gitProperties != null) {
            if (this.showGitBranch && StringUtils.hasText((String)this.gitProperties.getBranch())) {
                gitBranch = this.gitProperties.getBranch();
            }
            if (this.showGitCommitId && StringUtils.hasText((String)this.gitProperties.getCommitId())) {
                gitCommitId = this.gitProperties.getCommitId();
            }
            if (this.showGitShortCommitId && StringUtils.hasText((String)this.gitProperties.getShortCommitId())) {
                gitShortCommitId = this.gitProperties.getShortCommitId();
            }
            if (this.showGitCommitTime && this.gitProperties.getCommitTime() != null) {
                gitCommitTime = this.gitProperties.getCommitTime().toString();
            }
        }
        attributes.put("buildGroup", buildGroup);
        attributes.put("buildArtifact", buildArtifact);
        attributes.put("buildName", buildName);
        attributes.put("buildVersion", buildVersion);
        attributes.put("buildTime", buildTime);
        attributes.put("gitBranch", gitBranch);
        attributes.put("gitCommitId", gitCommitId);
        attributes.put("gitShortCommitId", gitShortCommitId);
        attributes.put("gitCommitTime", gitCommitTime);
        AttributedString rendered = this.templateExecutor.render(templateResource, attributes);
        return rendered;
    }

    public void setBuildProperties(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    public void setGitProperties(GitProperties gitProperties) {
        this.gitProperties = gitProperties;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setShowBuildGroup(boolean showBuildGroup) {
        this.showBuildGroup = showBuildGroup;
    }

    public void setShowBuildArtifact(boolean showBuildArtifact) {
        this.showBuildArtifact = showBuildArtifact;
    }

    public void setShowBuildName(boolean showBuildName) {
        this.showBuildName = showBuildName;
    }

    public void setShowBuildVersion(boolean showBuildVersion) {
        this.showBuildVersion = showBuildVersion;
    }

    public void setShowBuildTime(boolean showBuildTime) {
        this.showBuildTime = showBuildTime;
    }

    public void setShowGitBranch(boolean showGitBranch) {
        this.showGitBranch = showGitBranch;
    }

    public void setShowGitCommitId(boolean showGitCommitId) {
        this.showGitCommitId = showGitCommitId;
    }

    public void setShowGitShortCommitId(boolean showGitShortCommitId) {
        this.showGitShortCommitId = showGitShortCommitId;
    }

    public void setShowGitCommitTime(boolean showGitCommitTime) {
        this.showGitCommitTime = showGitCommitTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resourceAsString(Resource resource) {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static interface Command {
    }
}

