/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.standard.commands.CommandInfoModel;
import org.springframework.shell.standard.commands.GroupCommandInfoModel;
import org.springframework.util.StringUtils;

class GroupsInfoModel {
    private boolean showGroups = true;
    private final List<GroupCommandInfoModel> groups;
    private final List<CommandInfoModel> commands;
    private boolean hasUnavailableCommands = false;

    GroupsInfoModel(boolean showGroups, List<GroupCommandInfoModel> groups, List<CommandInfoModel> commands, boolean hasUnavailableCommands) {
        this.showGroups = showGroups;
        this.groups = groups;
        this.commands = commands;
        this.hasUnavailableCommands = hasUnavailableCommands;
    }

    static GroupsInfoModel of(boolean showGroups, Map<String, CommandRegistration> registrations) {
        HashSet<CommandRegistration> regsWithoutAliases = new HashSet<CommandRegistration>(registrations.values());
        SortedMap commandsByGroupAndName = regsWithoutAliases.stream().collect(Collectors.toMap(r -> r.getCommand(), r -> r)).entrySet().stream().collect(Collectors.groupingBy(e -> StringUtils.hasText((String)((CommandRegistration)e.getValue()).getGroup()) ? ((CommandRegistration)e.getValue()).getGroup() : "Default", TreeMap::new, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        List<GroupCommandInfoModel> gcims = commandsByGroupAndName.entrySet().stream().map(e -> {
            List<CommandInfoModel> cims = ((Map)e.getValue()).entrySet().stream().map(ee -> CommandInfoModel.of((String)ee.getKey(), (CommandRegistration)ee.getValue())).collect(Collectors.toList());
            return GroupCommandInfoModel.of((String)e.getKey(), cims);
        }).collect(Collectors.toList());
        List<CommandInfoModel> commands = gcims.stream().flatMap(gcim -> gcim.getCommands().stream()).collect(Collectors.toList());
        boolean hasUnavailableCommands = commands.stream().map(c -> {
            if (c.getAvailability() != null) {
                return c.getAvailability().getAvailable();
            }
            return true;
        }).filter(a -> a == false).findFirst().isPresent();
        return new GroupsInfoModel(showGroups, gcims, commands, hasUnavailableCommands);
    }

    public boolean getShowGroups() {
        return this.showGroups;
    }

    public List<GroupCommandInfoModel> getGroups() {
        return this.groups;
    }

    public List<CommandInfoModel> getCommands() {
        return this.commands;
    }

    public boolean getHasUnavailableCommands() {
        return this.hasUnavailableCommands;
    }
}

