/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;

public abstract class AbstractArgumentMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public static final String ARGUMENT_PREFIX = "springShellArgument.";
    private final ConversionService conversionService;
    @Nullable
    private final ConfigurableBeanFactory configurableBeanFactory;
    @Nullable
    private final BeanExpressionContext expressionContext;
    private final Map<MethodParameter, NamedValueInfo> namedValueInfoCache = new ConcurrentHashMap<MethodParameter, NamedValueInfo>(256);

    protected AbstractArgumentMethodArgumentResolver(ConversionService conversionService, @Nullable ConfigurableBeanFactory beanFactory) {
        this.conversionService = conversionService != null ? conversionService : DefaultConversionService.getSharedInstance();
        this.configurableBeanFactory = beanFactory;
        this.expressionContext = beanFactory != null ? new BeanExpressionContext(beanFactory, null) : null;
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        NamedValueInfo namedValueInfo = this.getNamedValueInfo(parameter);
        MethodParameter nestedParameter = parameter.nestedIfOptional();
        Object arg = this.resolveArgumentInternal(nestedParameter, message, namedValueInfo.names);
        if (arg == null) {
            if (namedValueInfo.defaultValue != null) {
                arg = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
            } else if (namedValueInfo.required && !nestedParameter.isOptional()) {
                this.handleMissingValue(namedValueInfo.names, nestedParameter, message);
            }
            arg = this.handleNullValue(namedValueInfo.names, arg, nestedParameter.getNestedParameterType());
        } else if ("".equals(arg) && namedValueInfo.defaultValue != null) {
            arg = this.resolveEmbeddedValuesAndExpressions(namedValueInfo.defaultValue);
        }
        if (!(parameter == nestedParameter && ClassUtils.isAssignableValue((Class)parameter.getParameterType(), (Object)arg) || (arg = this.conversionService.convert(arg, TypeDescriptor.forObject((Object)arg), new TypeDescriptor(parameter))) != null || namedValueInfo.defaultValue != null || !namedValueInfo.required || nestedParameter.isOptional())) {
            this.handleMissingValue(namedValueInfo.names, nestedParameter, message);
        }
        this.handleResolvedValue(arg, namedValueInfo.names, parameter, message);
        return arg;
    }

    private NamedValueInfo getNamedValueInfo(MethodParameter parameter) {
        NamedValueInfo namedValueInfo = this.namedValueInfoCache.get(parameter);
        if (namedValueInfo == null) {
            namedValueInfo = this.createNamedValueInfo(parameter);
            namedValueInfo = this.updateNamedValueInfo(parameter, namedValueInfo);
            this.namedValueInfoCache.put(parameter, namedValueInfo);
        }
        return namedValueInfo;
    }

    protected abstract NamedValueInfo createNamedValueInfo(MethodParameter var1);

    private NamedValueInfo updateNamedValueInfo(MethodParameter parameter, NamedValueInfo info) {
        List names = info.names;
        if (info.names.isEmpty()) {
            String name = parameter.getParameterName();
            if (name == null) {
                throw new IllegalArgumentException("Name for argument of type [" + parameter.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
            }
            names.add(name);
        }
        return new NamedValueInfo(names, info.required, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info.defaultValue) ? null : info.defaultValue);
    }

    @Nullable
    private Object resolveEmbeddedValuesAndExpressions(String value) {
        if (this.configurableBeanFactory == null || this.expressionContext == null) {
            return value;
        }
        String placeholdersResolved = this.configurableBeanFactory.resolveEmbeddedValue(value);
        BeanExpressionResolver exprResolver = this.configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return value;
        }
        return exprResolver.evaluate(placeholdersResolved, this.expressionContext);
    }

    @Nullable
    protected abstract Object resolveArgumentInternal(MethodParameter var1, Message<?> var2, List<String> var3) throws Exception;

    protected abstract void handleMissingValue(List<String> var1, MethodParameter var2, Message<?> var3);

    @Nullable
    private Object handleNullValue(List<String> name, @Nullable Object value, Class<?> paramType) {
        if (value == null) {
            if (Boolean.TYPE.equals(paramType)) {
                return Boolean.FALSE;
            }
            if (paramType.isPrimitive()) {
                throw new IllegalStateException("Optional " + paramType + " parameter '" + name + "' is present but cannot be translated into a null value due to being declared as a primitive type. Consider declaring it as object wrapper for the corresponding primitive type.");
            }
        }
        return value;
    }

    protected void handleResolvedValue(@Nullable Object arg, List<String> name, MethodParameter parameter, Message<?> message) {
    }

    protected static class NamedValueInfo {
        private final List<String> names;
        private final boolean required;
        @Nullable
        private final String defaultValue;

        protected NamedValueInfo(List<String> names, boolean required, @Nullable String defaultValue) {
            this.names = names;
            this.required = required;
            this.defaultValue = defaultValue;
        }
    }
}

