/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

import org.springframework.shell.style.FigureSettings;
import org.springframework.shell.style.StyleSettings;

public abstract class ThemeSettings {
    private StyleSettings styleSettings;
    private FigureSettings figureSettings;

    public ThemeSettings() {
        this(StyleSettings.dump(), FigureSettings.dump());
    }

    public ThemeSettings(StyleSettings styleSettings, FigureSettings figureSettings) {
        this.styleSettings = styleSettings;
        this.figureSettings = figureSettings;
    }

    public StyleSettings styles() {
        return this.styleSettings;
    }

    public FigureSettings figures() {
        return this.figureSettings;
    }

    public static ThemeSettings defaults() {
        return new DefaultThemeSettings(StyleSettings.defaults(), FigureSettings.defaults());
    }

    public static ThemeSettings dump() {
        return new DefaultThemeSettings();
    }

    private static class DefaultThemeSettings
    extends ThemeSettings {
        DefaultThemeSettings() {
        }

        DefaultThemeSettings(StyleSettings styleSettings, FigureSettings figureSettings) {
            super(styleSettings, figureSettings);
        }
    }
}

