/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.style.FigureSettings;
import org.springframework.shell.style.StringToStyleExpressionRenderer;
import org.springframework.shell.style.ThemeResolver;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupString;
import org.stringtemplate.v4.misc.STMessage;

public class TemplateExecutor {
    private static final Logger log = LoggerFactory.getLogger(TemplateExecutor.class);
    private static final STErrorListener ERROR_LISTENER = new LoggingSTErrorListener();
    private final ThemeResolver themeResolver;
    private StringToStyleExpressionRenderer renderer;

    public TemplateExecutor(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
        this.renderer = new StringToStyleExpressionRenderer(themeResolver);
    }

    public AttributedString render(String template, Map<String, Object> attributes) {
        STGroup group = new STGroup();
        group.setListener(ERROR_LISTENER);
        group.registerRenderer(String.class, (AttributeRenderer)this.renderer);
        ST st = new ST(group, template);
        if (attributes != null) {
            attributes.entrySet().stream().forEach(e -> st.add((String)e.getKey(), e.getValue()));
        }
        String templateRendered = st.render();
        return this.themeResolver.evaluateExpression(templateRendered);
    }

    public AttributedString renderGroup(String template, Map<String, Object> attributes) {
        STGroupString group = new STGroupString(template);
        group.setListener(ERROR_LISTENER);
        group.registerRenderer(String.class, (AttributeRenderer)this.renderer);
        Map<String, Object> figureDict = Stream.of(FigureSettings.tags()).collect(Collectors.toMap(tag -> tag, tag -> this.themeResolver.resolveFigureTag((String)tag)));
        group.defineDictionary("figures", figureDict);
        ST st = group.getInstanceOf("main");
        if (st == null) {
            throw new IllegalArgumentException("template instance 'main' not found from a group");
        }
        if (attributes != null) {
            attributes.entrySet().stream().forEach(e -> st.add((String)e.getKey(), e.getValue()));
        }
        String templateRendered = st.render();
        log.debug("Rendered template {}", (Object)templateRendered);
        return this.themeResolver.evaluateExpression(templateRendered);
    }

    private static class LoggingSTErrorListener
    implements STErrorListener {
        private static final Logger log = LoggerFactory.getLogger(LoggingSTErrorListener.class);

        private LoggingSTErrorListener() {
        }

        public void compileTimeError(STMessage msg) {
            log.debug("compileTimeError [{}]", (Object)msg);
        }

        public void runTimeError(STMessage msg) {
            log.debug("runTimeError [{}]", (Object)msg);
        }

        public void IOError(STMessage msg) {
            log.debug("IOError [{}]", (Object)msg);
        }

        public void internalError(STMessage msg) {
            log.debug("internalError [{}]", (Object)msg);
        }
    }
}

