/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.result;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.shell.ResultHandler;
import org.springframework.shell.ResultHandlerService;
import org.springframework.shell.result.GenericResultHandler;
import org.springframework.shell.result.ResultHandlerNotFoundException;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GenericResultHandlerService
implements ResultHandlerService {
    private final ResultHandlers resultHandlers = new ResultHandlers();

    @Override
    public void handle(Object source) {
        this.handle(source, TypeDescriptor.forObject((Object)source));
    }

    @Override
    public void handle(Object result, TypeDescriptor resultType) {
        if (result == null) {
            return;
        }
        GenericResultHandler handler = this.getResultHandler(resultType);
        if (handler != null) {
            GenericResultHandlerService.invokeHandler(handler, result, resultType);
            return;
        }
        this.handleResultHandlerNotFound(result, resultType);
    }

    public void addResultHandler(ResultHandler<?> resultHandler) {
        ResolvableType[] typeInfo = this.getRequiredTypeInfo(resultHandler.getClass(), ResultHandler.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine result type <T> for your ResultHandler [" + resultHandler.getClass().getName() + "]; does the class parameterize those types?");
        }
        this.addResultHandler(new ResultHandlerAdapter(resultHandler, typeInfo[0]));
    }

    public <T> void addResultHandler(Class<T> resultType, ResultHandler<? super T> resultHandler) {
        this.addResultHandler(new ResultHandlerAdapter(resultHandler, ResolvableType.forClass(resultType)));
    }

    public void addResultHandler(GenericResultHandler handler) {
        this.resultHandlers.add(handler);
    }

    private GenericResultHandler getResultHandler(TypeDescriptor resultType) {
        return this.resultHandlers.find(resultType);
    }

    @Nullable
    private Object handleResultHandlerNotFound(@Nullable Object source, @Nullable TypeDescriptor sourceType) {
        if (source == null) {
            return null;
        }
        if (sourceType == null) {
            return source;
        }
        throw new ResultHandlerNotFoundException(sourceType);
    }

    @Nullable
    private ResolvableType[] getRequiredTypeInfo(Class<?> handlerClass, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.forClass(handlerClass).as(genericIfc);
        ResolvableType[] generics = resolvableType.getGenerics();
        if (generics.length < 1) {
            return null;
        }
        Class resultType = generics[0].resolve();
        if (resultType == null) {
            return null;
        }
        return generics;
    }

    private static void invokeHandler(GenericResultHandler handler, Object result, TypeDescriptor resultType) {
        handler.handle(result, resultType);
    }

    private static class ResultHandlers {
        private final Set<GenericResultHandler> globalHandlers = new CopyOnWriteArraySet<GenericResultHandler>();
        private final Map<Class<?>, ResultHandlersForType> handlers = new ConcurrentHashMap(16);

        private ResultHandlers() {
        }

        public void add(GenericResultHandler handler) {
            Set<Class<?>> handlerTypes = handler.getHandlerTypes();
            if (handlerTypes == null) {
                this.globalHandlers.add(handler);
            } else {
                for (Class<?> handlerType : handlerTypes) {
                    this.getMatchableConverters(handlerType).add(handler);
                }
            }
        }

        private ResultHandlersForType getMatchableConverters(Class<?> handlerType) {
            return this.handlers.computeIfAbsent(handlerType, k -> new ResultHandlersForType());
        }

        public GenericResultHandler find(TypeDescriptor resultType) {
            List<Class<?>> resultCandidates = this.getClassHierarchy(resultType.getType());
            for (Class<?> resultCandidate : resultCandidates) {
                GenericResultHandler handler = this.getRegisteredHandler(resultType, resultCandidate);
                if (handler == null) continue;
                return handler;
            }
            return null;
        }

        @Nullable
        private GenericResultHandler getRegisteredHandler(TypeDescriptor resultType, Class<?> handlerType) {
            GenericResultHandler handler;
            ResultHandlersForType resultHandlersForType = this.handlers.get(handlerType);
            if (resultHandlersForType != null && (handler = resultHandlersForType.getHandler(resultType)) != null) {
                return handler;
            }
            for (GenericResultHandler globalHandler : this.globalHandlers) {
                if (!globalHandler.matches(resultType)) continue;
                return globalHandler;
            }
            return null;
        }

        private List<Class<?>> getClassHierarchy(Class<?> type) {
            ArrayList hierarchy = new ArrayList(20);
            HashSet visited = new HashSet(20);
            this.addToClassHierarchy(0, ClassUtils.resolvePrimitiveIfNecessary(type), false, hierarchy, visited);
            boolean array = type.isArray();
            for (int i = 0; i < hierarchy.size(); ++i) {
                Class candidate = (Class)hierarchy.get(i);
                candidate = array ? candidate.getComponentType() : ClassUtils.resolvePrimitiveIfNecessary((Class)candidate);
                Class superclass = candidate.getSuperclass();
                if (superclass != null && superclass != Object.class && superclass != Enum.class) {
                    this.addToClassHierarchy(i + 1, candidate.getSuperclass(), array, hierarchy, visited);
                }
                this.addInterfacesToClassHierarchy(candidate, array, hierarchy, visited);
            }
            if (Enum.class.isAssignableFrom(type)) {
                this.addToClassHierarchy(hierarchy.size(), Enum.class, array, hierarchy, visited);
                this.addToClassHierarchy(hierarchy.size(), Enum.class, false, hierarchy, visited);
                this.addInterfacesToClassHierarchy(Enum.class, array, hierarchy, visited);
            }
            this.addToClassHierarchy(hierarchy.size(), Object.class, array, hierarchy, visited);
            this.addToClassHierarchy(hierarchy.size(), Object.class, false, hierarchy, visited);
            return hierarchy;
        }

        private void addInterfacesToClassHierarchy(Class<?> type, boolean asArray, List<Class<?>> hierarchy, Set<Class<?>> visited) {
            for (Class<?> implementedInterface : type.getInterfaces()) {
                this.addToClassHierarchy(hierarchy.size(), implementedInterface, asArray, hierarchy, visited);
            }
        }

        private void addToClassHierarchy(int index, Class<?> type, boolean asArray, List<Class<?>> hierarchy, Set<Class<?>> visited) {
            if (asArray) {
                type = Array.newInstance(type, 0).getClass();
            }
            if (visited.add(type)) {
                hierarchy.add(index, type);
            }
        }
    }

    private static class ResultHandlersForType {
        private final Deque<GenericResultHandler> handlers = new ConcurrentLinkedDeque<GenericResultHandler>();

        private ResultHandlersForType() {
        }

        public void add(GenericResultHandler handler) {
            this.handlers.addFirst(handler);
        }

        @Nullable
        public GenericResultHandler getHandler(TypeDescriptor resultType) {
            for (GenericResultHandler handler : this.handlers) {
                if (!handler.matches(resultType)) continue;
                return handler;
            }
            return null;
        }

        public String toString() {
            return StringUtils.collectionToCommaDelimitedString(this.handlers);
        }
    }

    private static final class ResultHandlerAdapter
    implements GenericResultHandler {
        ResultHandler<Object> handler;
        Class<?> result;

        public ResultHandlerAdapter(ResultHandler<?> handler, ResolvableType resultType) {
            this.handler = handler;
            this.result = resultType.toClass();
        }

        @Override
        public Set<Class<?>> getHandlerTypes() {
            return Collections.singleton(this.result);
        }

        @Override
        public void handle(Object result, TypeDescriptor resultType) {
            this.handler.handleResult(result);
        }

        @Override
        public boolean matches(TypeDescriptor resultType) {
            return true;
        }
    }
}

