/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import org.jline.reader.Parser;
import org.springframework.boot.ApplicationArguments;
import org.springframework.core.annotation.Order;
import org.springframework.shell.Shell;
import org.springframework.shell.ShellRunner;
import org.springframework.shell.jline.FileInputProvider;
import org.springframework.util.ObjectUtils;

@Order(value=-100)
public class ScriptShellRunner
implements ShellRunner {
    public static final int PRECEDENCE = -100;
    private final Parser parser;
    private final Shell shell;

    public ScriptShellRunner(Parser parser, Shell shell) {
        this.parser = parser;
        this.shell = shell;
    }

    @Override
    public boolean canRun(ApplicationArguments args) {
        List scriptsToRun = args.getNonOptionArgs().stream().filter(s -> s.startsWith("@")).map(s -> new File(s.substring(1))).collect(Collectors.toList());
        return !ObjectUtils.isEmpty(scriptsToRun);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        List scriptsToRun = args.getNonOptionArgs().stream().filter(s -> s.startsWith("@")).map(s -> new File(s.substring(1))).collect(Collectors.toList());
        for (File file : scriptsToRun) {
            FileReader reader = new FileReader(file);
            Throwable throwable = null;
            try {
                FileInputProvider inputProvider = new FileInputProvider(reader, this.parser);
                Throwable throwable2 = null;
                try {
                    this.shell.run(inputProvider);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (inputProvider == null) continue;
                    if (throwable2 != null) {
                        try {
                            inputProvider.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    inputProvider.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
    }
}

