/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.springframework.boot.ApplicationArguments;
import org.springframework.core.annotation.Order;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.Shell;
import org.springframework.shell.ShellRunner;
import org.springframework.shell.Utils;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;

@Order(value=-50)
public class NonInteractiveShellRunner
implements ShellRunner {
    public static final int PRECEDENCE = -50;
    private final Shell shell;
    private final ShellContext shellContext;
    private Parser lineParser;
    private Function<ApplicationArguments, List<String>> commandsFromInputArgs = args -> args.getSourceArgs().length == 0 ? Collections.emptyList() : Collections.singletonList(String.join((CharSequence)" ", args.getSourceArgs()));

    public NonInteractiveShellRunner(Shell shell, ShellContext shellContext) {
        this.shell = shell;
        this.shellContext = shellContext;
        this.lineParser = new DefaultParser();
    }

    public void setCommandsFromInputArgs(Function<ApplicationArguments, List<String>> commandsFromInputArgs) {
        this.commandsFromInputArgs = commandsFromInputArgs;
    }

    public void setLineParser(Parser lineParser) {
        this.lineParser = lineParser;
    }

    @Override
    public boolean canRun(ApplicationArguments args) {
        return !this.commandsFromInputArgs.apply(args).isEmpty();
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        this.shellContext.setInteractionMode(InteractionMode.NONINTERACTIVE);
        List<String> commands = this.commandsFromInputArgs.apply(args);
        List<ParsedLine> parsedLines = commands.stream().map(rawCommandLine -> this.lineParser.parse(rawCommandLine, rawCommandLine.length() + 1)).collect(Collectors.toList());
        MultiParsedLineInputProvider inputProvider = new MultiParsedLineInputProvider(parsedLines);
        this.shell.run(inputProvider);
    }

    static class MultiParsedLineInputProvider
    implements InputProvider {
        private final List<ParsedLineInput> parsedLineInputs;
        private int inputIdx;

        MultiParsedLineInputProvider(List<ParsedLine> parsedLines) {
            this.parsedLineInputs = parsedLines.stream().map(ParsedLineInput::new).collect(Collectors.toList());
        }

        @Override
        public Input readInput() {
            if (this.inputIdx == this.parsedLineInputs.size()) {
                return null;
            }
            return this.parsedLineInputs.get(this.inputIdx++);
        }

        private static class ParsedLineInput
        implements Input {
            private final ParsedLine parsedLine;

            ParsedLineInput(ParsedLine parsedLine) {
                this.parsedLine = parsedLine;
            }

            @Override
            public String rawText() {
                return this.parsedLine.line();
            }

            @Override
            public List<String> words() {
                return Utils.sanitizeInput(this.parsedLine.words());
            }
        }
    }
}

