/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.support;

import org.springframework.shell.component.support.Enableable;
import org.springframework.shell.component.support.Itemable;
import org.springframework.shell.component.support.Matchable;
import org.springframework.shell.component.support.Nameable;
import org.springframework.shell.component.support.Selectable;
import org.springframework.util.StringUtils;

public interface SelectorItem<T>
extends Nameable,
Matchable,
Enableable,
Selectable,
Itemable<T> {
    public static <T> SelectorItem<T> of(String name, T item) {
        return SelectorItem.of(name, item, true, false);
    }

    public static <T> SelectorItem<T> of(String name, T item, boolean enabled, boolean selected) {
        return new SelectorItemWrapper<T>(name, item, enabled, selected);
    }

    public static class SelectorItemWrapper<T>
    implements SelectorItem<T> {
        private String name;
        private boolean enabled;
        private T item;
        private boolean selected;

        public SelectorItemWrapper(String name, T item) {
            this(name, item, true, false);
        }

        public SelectorItemWrapper(String name, T item, boolean enabled, boolean selected) {
            this.name = name;
            this.item = item;
            this.enabled = enabled;
            this.selected = selected;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean matches(String match) {
            if (!StringUtils.hasText((String)match)) {
                return true;
            }
            return this.name.toLowerCase().contains(match.toLowerCase());
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public T getItem() {
            return this.item;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }
    }
}

