/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractSelectorComponent;
import org.springframework.shell.component.support.Itemable;
import org.springframework.shell.component.support.Matchable;
import org.springframework.shell.component.support.Nameable;
import org.springframework.shell.component.support.Selectable;

public class SingleItemSelector<T, I extends Nameable & Matchable & Selectable>
extends AbstractSelectorComponent<T, SingleItemSelectorContext<T, I>, I> {
    private SingleItemSelectorContext<T, I> currentContext;

    public SingleItemSelector(Terminal terminal, List<I> items, String name, Comparator<I> comparator) {
        super(terminal, name, items, true, comparator);
        this.setRenderer(new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/single-item-selector-default.stg");
    }

    @Override
    public SingleItemSelectorContext<T, I> getThisContext(ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = SingleItemSelectorContext.empty(this.getItemMapper());
        this.currentContext.setName(this.name);
        if (this.currentContext.getItems() == null) {
            this.currentContext.setItems(this.getItems());
        }
        context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        return this.currentContext;
    }

    @Override
    protected SingleItemSelectorContext<T, I> runInternal(SingleItemSelectorContext<T, I> context) {
        super.runInternal(context);
        if (this.hasTty()) {
            this.loop(context);
        }
        return context;
    }

    private class DefaultRenderer
    implements Function<SingleItemSelectorContext<T, I>, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(SingleItemSelectorContext<T, I> context) {
            return SingleItemSelector.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    private static class DefaultSingleItemSelectorContext<T, I extends Nameable & Matchable>
    extends AbstractSelectorComponent.BaseSelectorComponentContext<T, I, SingleItemSelectorContext<T, I>>
    implements SingleItemSelectorContext<T, I> {
        private Function<T, String> itemMapper = item -> item.toString();

        DefaultSingleItemSelectorContext() {
        }

        DefaultSingleItemSelectorContext(Function<T, String> itemMapper) {
            this.itemMapper = itemMapper;
        }

        @Override
        public Optional<I> getResultItem() {
            if (this.getResultItems() == null) {
                return Optional.empty();
            }
            return this.getResultItems().stream().findFirst();
        }

        @Override
        public Optional<String> getValue() {
            return this.getResultItem().map(item -> this.itemMapper.apply(((Itemable)((Object)item)).getItem()));
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            this.getValue().ifPresent(value -> attributes.put("value", value));
            List rows = this.getItemStateView().stream().map(is -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", is.getName());
                map.put("selected", this.getCursorRow().intValue() == is.getIndex());
                return map;
            }).collect(Collectors.toList());
            attributes.put("rows", rows);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }

        @Override
        public String toString() {
            return "DefaultSingleItemSelectorContext [super=" + super.toString() + "]";
        }
    }

    public static interface SingleItemSelectorContext<T, I extends Nameable & Matchable>
    extends AbstractSelectorComponent.SelectorComponentContext<T, I, SingleItemSelectorContext<T, I>> {
        public Optional<I> getResultItem();

        public Optional<String> getValue();

        public static <C, I extends Nameable & Matchable> SingleItemSelectorContext<C, I> empty() {
            return new DefaultSingleItemSelectorContext();
        }

        public static <C, I extends Nameable & Matchable> SingleItemSelectorContext<C, I> empty(Function<C, String> itemMapper) {
            return new DefaultSingleItemSelectorContext(itemMapper);
        }
    }
}

