/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractSelectorComponent;
import org.springframework.shell.component.support.Itemable;
import org.springframework.shell.component.support.Matchable;
import org.springframework.shell.component.support.Nameable;
import org.springframework.shell.component.support.Selectable;

public class MultiItemSelector<T, I extends Nameable & Matchable & Selectable>
extends AbstractSelectorComponent<T, MultiItemSelectorContext<T, I>, I> {
    private MultiItemSelectorContext<T, I> currentContext;

    public MultiItemSelector(Terminal terminal, List<I> items, String name, Comparator<I> comparator) {
        super(terminal, name, items, false, comparator);
        this.setRenderer(new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/multi-item-selector-default.stg");
    }

    @Override
    public MultiItemSelectorContext<T, I> getThisContext(ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = MultiItemSelectorContext.empty(this.getItemMapper());
        this.currentContext.setName(this.name);
        if (this.currentContext.getItems() == null) {
            this.currentContext.setItems(this.getItems());
        }
        context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        return this.currentContext;
    }

    @Override
    protected MultiItemSelectorContext<T, I> runInternal(MultiItemSelectorContext<T, I> context) {
        super.runInternal(context);
        if (this.hasTty()) {
            this.loop(context);
        }
        return context;
    }

    private class DefaultRenderer
    implements Function<MultiItemSelectorContext<T, I>, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(MultiItemSelectorContext<T, I> context) {
            return MultiItemSelector.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    private static class DefaultMultiItemSelectorContext<T, I extends Nameable & Matchable>
    extends AbstractSelectorComponent.BaseSelectorComponentContext<T, I, MultiItemSelectorContext<T, I>>
    implements MultiItemSelectorContext<T, I> {
        private Function<T, String> itemMapper = item -> item.toString();

        DefaultMultiItemSelectorContext() {
        }

        DefaultMultiItemSelectorContext(Function<T, String> itemMapper) {
            this.itemMapper = itemMapper;
        }

        @Override
        public List<String> getValues() {
            if (this.getResultItems() == null) {
                return Collections.emptyList();
            }
            return this.getResultItems().stream().map(i -> ((Itemable)((Object)i)).getItem()).map(i -> this.itemMapper.apply(i)).collect(Collectors.toList());
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            attributes.put("values", this.getValues());
            List rows = this.getItemStateView().stream().map(is -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", is.getName());
                map.put("selected", is.isSelected());
                map.put("onrow", this.getCursorRow().intValue() == is.getIndex());
                map.put("enabled", is.isEnabled());
                return map;
            }).collect(Collectors.toList());
            attributes.put("rows", rows);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }
    }

    public static interface MultiItemSelectorContext<T, I extends Nameable & Matchable>
    extends AbstractSelectorComponent.SelectorComponentContext<T, I, MultiItemSelectorContext<T, I>> {
        public List<String> getValues();

        public static <T, I extends Nameable & Matchable> MultiItemSelectorContext<T, I> empty() {
            return new DefaultMultiItemSelectorContext();
        }

        public static <T, I extends Nameable & Matchable> MultiItemSelectorContext<T, I> empty(Function<T, String> itemMapper) {
            return new DefaultMultiItemSelectorContext(itemMapper);
        }
    }
}

