/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.shell.Utils;
import org.springframework.shell.command.CommandOption;
import org.springframework.util.StringUtils;

public interface CommandParser {
    public CommandParserResults parse(List<CommandOption> var1, String[] var2);

    public static CommandParser of() {
        return CommandParser.of(null);
    }

    public static CommandParser of(ConversionService conversionService) {
        return new DefaultCommandParser(conversionService);
    }

    public static class MissingOptionException
    extends CommandParserException {
        private CommandOption option;

        public MissingOptionException(String message, CommandOption option) {
            super(message);
            this.option = option;
        }

        public static MissingOptionException of(String message, CommandOption option) {
            return new MissingOptionException(message, option);
        }

        public CommandOption getOption() {
            return this.option;
        }
    }

    public static class CommandParserException
    extends RuntimeException {
        public CommandParserException(String message) {
            super(message);
        }

        public CommandParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public static CommandParserException of(String message) {
            return new CommandParserException(message);
        }
    }

    public static class DefaultCommandParser
    implements CommandParser {
        private final ConversionService conversionService;

        DefaultCommandParser(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        @Override
        public CommandParserResults parse(List<CommandOption> options, String[] args) {
            List requiredOptions = options.stream().filter(o -> o.isRequired()).collect(Collectors.toList());
            Lexer lexer = new Lexer(args);
            List<List<String>> lexerResults = lexer.visit();
            Parser parser = new Parser();
            ParserResults parserResults = parser.visit(lexerResults, options);
            ArrayList<CommandParserResult> results = new ArrayList<CommandParserResult>();
            ArrayList<String> positional = new ArrayList<String>();
            ArrayList<CommandParserException> errors = new ArrayList<CommandParserException>();
            parserResults.results.stream().forEach(pr -> {
                if (((ParserResult)pr).option != null) {
                    results.add(new DefaultCommandParserResult(((ParserResult)pr).option, ((ParserResult)pr).value));
                    requiredOptions.remove(((ParserResult)pr).option);
                } else {
                    positional.addAll(((ParserResult)pr).args);
                }
                if (((ParserResult)pr).error != null) {
                    errors.add(((ParserResult)pr).error);
                }
            });
            ArrayDeque queue = new ArrayDeque(parserResults.results);
            options.stream().filter(o -> o.getPosition() > -1).sorted(Comparator.comparingInt(o -> o.getPosition())).forEach(o -> {
                int arityMin = o.getArityMin();
                int arityMax = o.getArityMax();
                ArrayList<String> oargs = new ArrayList<String>();
                if (arityMin > -1) {
                    for (int i = 0; i < arityMax; ++i) {
                        ParserResult pop = null;
                        if (queue.isEmpty()) break;
                        pop = (ParserResult)queue.pop();
                        if (pop == null || pop.option != null || pop.args.isEmpty()) continue;
                        oargs.add(pop.args.stream().collect(Collectors.joining(" ")));
                    }
                }
                if (!oargs.isEmpty()) {
                    results.add(new DefaultCommandParserResult((CommandOption)o, oargs.stream().collect(Collectors.joining(" "))));
                    requiredOptions.remove(o);
                }
            });
            requiredOptions.stream().forEach(o -> {
                String ln = o.getLongNames() != null ? Stream.of(o.getLongNames()).collect(Collectors.joining(",")) : "";
                String sn = o.getShortNames() != null ? Stream.of(o.getShortNames()).map(n -> Character.toString(n.charValue())).collect(Collectors.joining(",")) : "";
                errors.add(MissingOptionException.of(String.format("Missing option, longnames='%s', shortnames='%s'", ln, sn), o));
            });
            return new DefaultCommandParserResults(results, positional, errors);
        }

        private static class Lexer {
            private final String[] args;

            Lexer(String[] args) {
                this.args = args;
            }

            List<List<String>> visit() {
                return Utils.split(this.args, t -> t.startsWith("-"));
            }
        }

        private class Parser {
            private Parser() {
            }

            ParserResults visit(List<List<String>> lexerResults, List<CommandOption> options) {
                List<ParserResult> results = lexerResults.stream().flatMap(lr -> {
                    List<CommandOption> option = this.matchOptions(options, (String)lr.get(0));
                    if (option.isEmpty()) {
                        return lr.stream().map(a -> ParserResult.of(null, Arrays.asList(a), null, null));
                    }
                    return option.stream().flatMap(o -> {
                        List<String> subArgs = lr.subList(1, lr.size());
                        ConvertArgumentsHolder holder = this.convertArguments((CommandOption)o, subArgs);
                        Object value = holder.value;
                        Stream<ParserResult> unmapped = holder.unmapped.stream().map(um -> ParserResult.of(null, Arrays.asList(um), null, null));
                        Stream<ParserResult> res = Stream.of(ParserResult.of(o, subArgs, value, null));
                        return Stream.concat(res, unmapped);
                    });
                }).collect(Collectors.toList());
                ArrayList<CommandOption> defaultValueOptionsToCheck = new ArrayList<CommandOption>(options);
                results.stream().forEach(pr -> {
                    if (((ParserResult)pr).option != null) {
                        defaultValueOptionsToCheck.remove(((ParserResult)pr).option);
                    }
                });
                defaultValueOptionsToCheck.stream().filter(co -> co.getDefaultValue() != null).forEach(co -> {
                    Object value = co.getDefaultValue();
                    if (DefaultCommandParser.this.conversionService != null && co.getType() != null && DefaultCommandParser.this.conversionService.canConvert(co.getDefaultValue().getClass(), co.getType().getRawClass())) {
                        value = DefaultCommandParser.this.conversionService.convert((Object)co.getDefaultValue(), co.getType().getRawClass());
                    }
                    results.add(ParserResult.of(co, Collections.emptyList(), value, null));
                });
                return ParserResults.of(results);
            }

            private List<CommandOption> matchOptions(List<CommandOption> options, String arg) {
                ArrayList<CommandOption> matched = new ArrayList<CommandOption>();
                String trimmed = StringUtils.trimLeadingCharacter((String)arg, (char)'-');
                int count = arg.length() - trimmed.length();
                if (count == 1) {
                    if (trimmed.length() == 1) {
                        Character trimmedChar = Character.valueOf(trimmed.charAt(0));
                        options.stream().filter(o -> {
                            for (Character sn : o.getShortNames()) {
                                if (!trimmedChar.equals(sn)) continue;
                                return true;
                            }
                            return false;
                        }).findFirst().ifPresent(o -> matched.add((CommandOption)o));
                    } else if (trimmed.length() > 1) {
                        trimmed.chars().mapToObj(i -> Character.valueOf((char)i)).forEach(c -> options.stream().forEach(o -> {
                            for (Character sn : o.getShortNames()) {
                                if (!c.equals(sn)) continue;
                                matched.add((CommandOption)o);
                            }
                        }));
                    }
                } else if (count == 2) {
                    options.stream().filter(o -> {
                        for (String ln : o.getLongNames()) {
                            if (!trimmed.equals(ln)) continue;
                            return true;
                        }
                        return false;
                    }).findFirst().ifPresent(o -> matched.add((CommandOption)o));
                }
                return matched;
            }

            private ConvertArgumentsHolder convertArguments(CommandOption option, List<String> arguments) {
                Object value = null;
                ArrayList<String> unmapped = new ArrayList<String>();
                ResolvableType type = option.getType();
                int arityMin = option.getArityMin();
                int arityMax = option.getArityMax();
                if (arityMin < 0 && type != null && type.isAssignableFrom(Boolean.TYPE)) {
                    arityMin = 1;
                    arityMax = 1;
                }
                if (type != null && type.isAssignableFrom(Boolean.TYPE)) {
                    value = arguments.size() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(Boolean.parseBoolean(arguments.get(0)));
                } else if (type != null && type.isArray()) {
                    value = arguments.stream().collect(Collectors.toList()).toArray();
                } else if (!arguments.isEmpty()) {
                    if (arguments.size() == 1) {
                        value = arguments.get(0);
                    } else if (arityMax > 0) {
                        int limit = Math.min(arguments.size(), arityMax);
                        value = arguments.stream().limit(limit).collect(Collectors.joining(" "));
                        unmapped.addAll(arguments.subList(limit, arguments.size()));
                    } else {
                        value = arguments.get(0);
                        unmapped.addAll(arguments.subList(1, arguments.size()));
                    }
                }
                return new ConvertArgumentsHolder(value, unmapped);
            }

            private class ConvertArgumentsHolder {
                Object value;
                final List<String> unmapped = new ArrayList<String>();

                ConvertArgumentsHolder(Object value, List<String> unmapped) {
                    this.value = value;
                    if (unmapped != null) {
                        this.unmapped.addAll(unmapped);
                    }
                }
            }
        }

        private static class ParserResults {
            private List<ParserResult> results;

            private ParserResults(List<ParserResult> results) {
                this.results = results;
            }

            static ParserResults of(List<ParserResult> results) {
                return new ParserResults(results);
            }
        }

        private static class ParserResult {
            private CommandOption option;
            private List<String> args;
            private Object value;
            private CommandParserException error;

            private ParserResult(CommandOption option, List<String> args, Object value, CommandParserException error) {
                this.option = option;
                this.args = args;
                this.value = value;
                this.error = error;
            }

            static ParserResult of(CommandOption option, List<String> args, Object value, CommandParserException error) {
                return new ParserResult(option, args, value, error);
            }
        }
    }

    public static class DefaultCommandParserResult
    implements CommandParserResult {
        private CommandOption option;
        private Object value;

        DefaultCommandParserResult(CommandOption option, Object value) {
            this.option = option;
            this.value = value;
        }

        @Override
        public CommandOption option() {
            return this.option;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    public static class DefaultCommandParserResults
    implements CommandParserResults {
        private List<CommandParserResult> results;
        private List<String> positional;
        private List<CommandParserException> errors;

        DefaultCommandParserResults(List<CommandParserResult> results, List<String> positional, List<CommandParserException> errors) {
            this.results = results;
            this.positional = positional;
            this.errors = errors;
        }

        @Override
        public List<CommandParserResult> results() {
            return this.results;
        }

        @Override
        public List<String> positional() {
            return this.positional;
        }

        @Override
        public List<CommandParserException> errors() {
            return this.errors;
        }
    }

    public static interface CommandParserResults {
        public List<CommandParserResult> results();

        public List<String> positional();

        public List<CommandParserException> errors();

        public static CommandParserResults of(List<CommandParserResult> results, List<String> positional, List<CommandParserException> errors) {
            return new DefaultCommandParserResults(results, positional, errors);
        }
    }

    public static interface CommandParserResult {
        public CommandOption option();

        public Object value();

        public static CommandParserResult of(CommandOption option, Object value) {
            return new DefaultCommandParserResult(option, value);
        }
    }
}

