/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.util.Objects;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface Command {

    public static class Help {
        private final String group;
        private final String description;

        public Help(String description) {
            this(description, null);
        }

        public Help(String description, String group) {
            Assert.isTrue((boolean)StringUtils.hasText((String)description), (String)"Command description cannot be null or empty");
            this.description = description;
            this.group = StringUtils.hasText((String)group) ? group : "";
        }

        public String getDescription() {
            return this.description;
        }

        public String getGroup() {
            return this.group;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Help help = (Help)o;
            return Objects.equals(this.group, help.group) && Objects.equals(this.description, help.description);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.description);
        }
    }
}

