/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.databasewriter.service;

import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.databasewriter.repository.ArchiveRepository;
import com.xebialabs.xlrelease.databasewriter.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.databasewriter.repository.ReleaseRepository;
import com.xebialabs.xlrelease.databasewriter.support.AnonymizeSupport;
import com.xebialabs.xlrelease.databasewriter.support.EncryptSupport;
import com.xebialabs.xlrelease.databasewriter.support.FileSupport;
import com.xebialabs.xlrelease.databasewriter.support.UsernamesCacheSupport;
import com.xebialabs.xlrelease.databasewriter.support.anonymize.TextAnonymizer;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000b}\u0003A\u0011\u00011\t\u000bM\u0004A\u0011\u0001;\t\u000b]\u0004A\u0011\u0001=\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\u0011aBU3mK\u0006\u001cXmU3sm&\u001cWM\u0003\u0002\u0010!\u000591/\u001a:wS\u000e,'BA\t\u0013\u00039!\u0017\r^1cCN,wO]5uKJT!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\u0019\u0001!\u0004\t\u0015/cA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\n\u0001b\u001a:jujdW\rZ\u0005\u0003O\t\u0012q\u0001T8hO&tw\r\u0005\u0002*Y5\t!F\u0003\u0002,!\u000591/\u001e9q_J$\u0018BA\u0017+\u0005-1\u0015\u000e\\3TkB\u0004xN\u001d;\u0011\u0005%z\u0013B\u0001\u0019+\u0005A\ten\u001c8z[&TXmU;qa>\u0014H\u000f\u0005\u0002*e%\u00111G\u000b\u0002\u000f\u000b:\u001c'/\u001f9u'V\u0004\bo\u001c:u\u0003-\u0011X\r\\3bg\u0016\u0014V\r]8\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002<q\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002\u0019I,G.Z1tKJ+\u0007o\u001c\u0011\u0002\u0017\u0005\u00148\r[5wKJ+\u0007o\\\u000b\u0002\u007fA\u0011q\u0007Q\u0005\u0003\u0003b\u0012\u0011#\u0011:dQ&4XMU3q_NLGo\u001c:z\u00031\t'o\u00195jm\u0016\u0014V\r]8!\u0003E\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\\u000b\u0002\u000bB\u0011qGR\u0005\u0003\u000fb\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002%\r|gNZ5hkJ\fG/[8o%\u0016\u0004x\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-kej\u0014\t\u0003\u0019\u0002i\u0011A\u0004\u0005\u0006i\u001d\u0001\rA\u000e\u0005\u0006{\u001d\u0001\ra\u0010\u0005\u0006\u0007\u001e\u0001\r!\u0012\u0015\u0003\u000fE\u0003\"AU/\u000e\u0003MS!\u0001V+\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002W/\u00069a-Y2u_JL(B\u0001-Z\u0003\u0015\u0011W-\u00198t\u0015\tQ6,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0016aA8sO&\u0011al\u0015\u0002\n\u0003V$xn^5sK\u0012\f1B]3bIJ+G.Z1tKR\u0019\u0011\rZ9\u0011\u0005m\u0011\u0017BA2\u001d\u0005\u0011)f.\u001b;\t\u000b\u0015D\u0001\u0019\u00014\u0002\u0013I,G.Z1tK&#\u0007CA4o\u001d\tAG\u000e\u0005\u0002j95\t!N\u0003\u0002l1\u00051AH]8pizJ!!\u001c\u000f\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[rAQA\u001d\u0005A\u0002\u0019\fAAZ5mK\u0006aqO]5uKJ+G.Z1tKR\u0019\u0011-\u001e<\t\u000b\u0015L\u0001\u0019\u00014\t\u000bIL\u0001\u0019\u00014\u0002\u0019\u0005twN\u001c*fY\u0016\f7/Z:\u0015\t\u0005L80 \u0005\u0006u*\u0001\rAZ\u0001\u0007Y>\u001c\u0017\r\\3\t\u000bqT\u0001\u0019\u00014\u00025\u0005$G-\u001b;j_:\fGNU3qY\u0006\u001cW-\\3oiN\u0004\u0016\r\u001e5\t\u000byT\u0001\u0019\u00014\u0002/\u0005twN\\=nSj\fG/[8o\u001fV$\b/\u001e;QCRD\u0017a\u0004:fC\u0012\fE\u000e\\!sG\"Lg/\u001a3\u0015\u001b\u0005\f\u0019!a\u0002\u0002\u0012\u0005M\u0011QCA\f\u0011\u0019\t)a\u0003a\u0001M\u0006!\u0001/\u0019;i\u0011\u001d\tIa\u0003a\u0001\u0003\u0017\t\u0011\"\u00198p]fl\u0017N_3\u0011\u0007m\ti!C\u0002\u0002\u0010q\u0011qAQ8pY\u0016\fg\u000eC\u0003{\u0017\u0001\u0007a\rC\u0003}\u0017\u0001\u0007a\rC\u0003\u007f\u0017\u0001\u0007a\rC\u0004\u0002\u001a-\u0001\r!a\u0003\u0002\u0019M\\\u0017\u000e]#ySN$\u0018N\\4\u0002\u001f\u0015t7M]=qiJ+G.Z1tKN$\u0012!\u0019\u0015\u0004\u0001\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001d\u0012,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u000b\u0002&\tI1i\\7q_:,g\u000e\u001e")
public class ReleaseService
implements AnonymizeSupport,
EncryptSupport {
    private final ReleaseRepository releaseRepo;
    private final ArchiveRepository archiveRepo;
    private final ConfigurationRepository configurationRepo;
    private String scriptUserPasswordRegex;
    private String scriptUserPasswordReplace;
    private String serverRegex;
    private String serverReplace;
    private String passwordRegex;
    private String passwordReplace;
    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations;
    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames;
    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames;
    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore;
    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$reservedJsonKeys;
    private Try<Set<String>> com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public String encryptJson(PasswordEncrypter encrypter, String json) {
        return EncryptSupport.encryptJson$(this, encrypter, json);
    }

    @Override
    public String reencryptPassword(String base64Password, PasswordEncrypter encrypter) {
        return EncryptSupport.reencryptPassword$(this, base64Password, encrypter);
    }

    @Override
    public String anonymizeJson(TextAnonymizer anonymizer, String json) {
        return AnonymizeSupport.anonymizeJson$(this, anonymizer, json);
    }

    @Override
    public String updateConfigurationType(String ciType) {
        return AnonymizeSupport.updateConfigurationType$(this, ciType);
    }

    @Override
    public void withAnonymizerIfRequested(boolean anonymize, String locale, String additionalReplacementsPath, String anonymizationOutputPath, Function1<Function1<String, String>, BoxedUnit> callable) {
        AnonymizeSupport.withAnonymizerIfRequested$(this, anonymize, locale, additionalReplacementsPath, anonymizationOutputPath, callable);
    }

    @Override
    public Try<Set<String>> getAllNames() {
        return UsernamesCacheSupport.getAllNames$(this);
    }

    @Override
    public void saveFile(String content, String file) {
        FileSupport.saveFile$(this, content, file);
    }

    @Override
    public Try<String> readFile(String file) {
        return FileSupport.readFile$(this, file);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public String scriptUserPasswordRegex() {
        return this.scriptUserPasswordRegex;
    }

    @Override
    public String scriptUserPasswordReplace() {
        return this.scriptUserPasswordReplace;
    }

    @Override
    public String serverRegex() {
        return this.serverRegex;
    }

    @Override
    public String serverReplace() {
        return this.serverReplace;
    }

    @Override
    public String passwordRegex() {
        return this.passwordRegex;
    }

    @Override
    public String passwordReplace() {
        return this.passwordReplace;
    }

    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations$lzycompute() {
        ReleaseService releaseService = this;
        synchronized (releaseService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations = AnonymizeSupport.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations;
    }

    @Override
    public Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations$lzycompute() : this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$locations;
    }

    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames$lzycompute() {
        ReleaseService releaseService = this;
        synchronized (releaseService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames = AnonymizeSupport.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames;
    }

    @Override
    public Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames$lzycompute() : this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$firstNames;
    }

    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames$lzycompute() {
        ReleaseService releaseService = this;
        synchronized (releaseService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames = AnonymizeSupport.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames;
    }

    @Override
    public Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames$lzycompute() : this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$surnames;
    }

    private Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore$lzycompute() {
        ReleaseService releaseService = this;
        synchronized (releaseService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore = AnonymizeSupport.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore;
    }

    @Override
    public Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore$lzycompute() : this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$ignore;
    }

    @Override
    public Set<String> com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$reservedJsonKeys() {
        return this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$reservedJsonKeys;
    }

    @Override
    public void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$scriptUserPasswordRegex_$eq(String x$1) {
        this.scriptUserPasswordRegex = x$1;
    }

    @Override
    public void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$scriptUserPasswordReplace_$eq(String x$1) {
        this.scriptUserPasswordReplace = x$1;
    }

    @Override
    public void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$serverRegex_$eq(String x$1) {
        this.serverRegex = x$1;
    }

    @Override
    public void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$serverReplace_$eq(String x$1) {
        this.serverReplace = x$1;
    }

    @Override
    public void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$passwordRegex_$eq(String x$1) {
        this.passwordRegex = x$1;
    }

    @Override
    public void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$passwordReplace_$eq(String x$1) {
        this.passwordReplace = x$1;
    }

    @Override
    public final void com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$_setter_$com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$reservedJsonKeys_$eq(Set<String> x$1) {
        this.com$xebialabs$xlrelease$databasewriter$support$AnonymizeSupport$$reservedJsonKeys = x$1;
    }

    private Try<Set<String>> com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames$lzycompute() {
        ReleaseService releaseService = this;
        synchronized (releaseService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames = UsernamesCacheSupport.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames;
    }

    @Override
    public Try<Set<String>> com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames$lzycompute() : this.com$xebialabs$xlrelease$databasewriter$support$UsernamesCacheSupport$$allNames;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseService releaseService = this;
        synchronized (releaseService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepo() {
        return this.releaseRepo;
    }

    @Override
    public ArchiveRepository archiveRepo() {
        return this.archiveRepo;
    }

    @Override
    public ConfigurationRepository configurationRepo() {
        return this.configurationRepo;
    }

    public void readRelease(String releaseId, String file) {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(18).append("reading release [").append(releaseId).append("]").toString());
        Try<String> try_ = this.releaseRepo().readReleaseJson(releaseId);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String json = (String)success.value();
            this.saveFile(json, file);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(26).append("no release found for id [").append(releaseId).append("]").toString(), (Function0 & Serializable)() -> throwable);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public void writeRelease(String releaseId, String file) {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(18).append("writing release [").append(releaseId).append("]").toString());
        Try<String> try_ = this.readFile(file);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String content = (String)success.value();
            this.releaseRepo().saveReleaseJson(releaseId, content);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(20).append("no file found for [").append(file).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void anonReleases(String locale, String additionalReplacementsPath, String anonymizationOutputPath) {
        this.logger().info((Function0 & Serializable)() -> "trying to anonymize all releases... this might take a while");
        this.withAnonymizerIfRequested(true, locale, additionalReplacementsPath, anonymizationOutputPath, (Function1<Function1<String, String>, BoxedUnit>)(Function1 & Serializable)anonymize -> {
            ReleaseService.$anonfun$anonReleases$2(this, anonymize);
            return BoxedUnit.UNIT;
        });
    }

    public void readAllArchived(String path, boolean anonymize, String locale, String additionalReplacementsPath, String anonymizationOutputPath, boolean skipExisting) {
        this.withAnonymizerIfRequested(anonymize, locale, additionalReplacementsPath, anonymizationOutputPath, (Function1<Function1<String, String>, BoxedUnit>)(Function1 & Serializable)anonymizer -> {
            ReleaseService.$anonfun$readAllArchived$1(this, path, skipExisting, anonymize, anonymizer);
            return BoxedUnit.UNIT;
        });
    }

    public void encryptReleases() {
        this.logger().info((Function0 & Serializable)() -> "trying to encrypt all releases... this might take a while");
        PasswordEncrypter encrypter = PasswordEncrypter.getInstance();
        this.releaseRepo().encryptReleases((Function1<String, String>)(Function1 & Serializable)json -> this.encryptJson(encrypter, (String)json));
        this.logger().info((Function0 & Serializable)() -> "Done encrypting relases");
    }

    public static final /* synthetic */ void $anonfun$anonReleases$2(ReleaseService $this, Function1 anonymize) {
        $this.releaseRepo().anonReleases((Function1<String, String>)anonymize);
    }

    public static final /* synthetic */ void $anonfun$readAllArchived$1(ReleaseService $this, String path$1, boolean skipExisting$1, boolean anonymize$1, Function1 anonymizer) {
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(51).append("Start reading all archived releases into directory ").append(path$1).toString());
        Seq<String> releaseIds = $this.archiveRepo().findAllReleaseIds();
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(48).append("Found ").append(releaseIds.size()).append(" archived releases, start downloading them").toString());
        long start = System.currentTimeMillis();
        AtomicInteger progress = new AtomicInteger(0);
        ((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(releaseIds).asJava()).parallelStream().forEach(releaseId -> {
            block6: {
                String file = new StringBuilder(6).append(path$1).append("/").append((String)releaseId).append(".json").toString();
                if (skipExisting$1 && new File(file).exists()) {
                    $this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Skipping release as it already exists on disk: ").append(file).toString());
                } else {
                    Try<String> try_ = $this.archiveRepo().readReleaseJson((String)releaseId, (Function1<String, String>)anonymizer);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        String json = (String)success.value();
                        new File(file).getParentFile().mkdirs();
                        $this.saveFile(json, file);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        $this.logger().error((Function0 & Serializable)() -> new StringBuilder(25).append("Could not read release ").append((String)releaseId).append(": ").append(e).toString(), (Function0 & Serializable)() -> e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(try_);
                    }
                }
                int nDone = progress.incrementAndGet();
                if (nDone % 1000 != 0) break block6;
                $this.logger().info((Function0 & Serializable)() -> new StringBuilder(42).append("  downloaded ").append(nDone).append(" out of ").append(releaseIds.size()).append(" archived releases...").toString());
            }
        });
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(21).append("Finished downloading ").append((Object)(anonymize$1 ? "and anonymizing " : "")).toString()).append(new StringBuilder(17).append(releaseIds.size()).append(" releases to ").append(path$1).append(" in ").append(duration).toString()).toString());
    }

    @Autowired
    public ReleaseService(ReleaseRepository releaseRepo, ArchiveRepository archiveRepo, ConfigurationRepository configurationRepo) {
        this.releaseRepo = releaseRepo;
        this.archiveRepo = archiveRepo;
        this.configurationRepo = configurationRepo;
        Logging.$init$((Logging)this);
        FileSupport.$init$(this);
        UsernamesCacheSupport.$init$(this);
        AnonymizeSupport.$init$(this);
        EncryptSupport.$init$(this);
        Statics.releaseFence();
    }
}

