/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.databasewriter.plumbing;

import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import scala.reflect.ScalaSignature;

@Primary
@Configuration
@ConfigurationProperties(prefix="xlr.datasource")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0007\u000e\u0001aAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001A\u0002\u0013\u0005A\u0006C\u0004;\u0001\u0001\u0007I\u0011A\u001e\t\r\t\u0003\u0001\u0015)\u0003.\u0011\u001d\t\u0006\u00011A\u0005\u00021BqA\u0015\u0001A\u0002\u0013\u00051\u000b\u0003\u0004V\u0001\u0001\u0006K!\f\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0011\u0019\u0019\u0007\u0001)A\u00057\")A\r\u0001C!K\")\u0001\u000e\u0001C\u0005S\niB)Z2ssB$XM\u001d#bi\u0006\u001cv.\u001e:dKB\u0013x\u000e]3si&,7O\u0003\u0002\u000f\u001f\u0005A\u0001\u000f\\;nE&twM\u0003\u0002\u0011#\u0005qA-\u0019;bE\u0006\u001cXm\u001e:ji\u0016\u0014(B\u0001\n\u0014\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0015+\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002-\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\u0007\t\u00035\u0015j\u0011a\u0007\u0006\u00039u\tAA\u001b3cG*\u0011adH\u0001\u000eCV$xnY8oM&<WO]3\u000b\u0005\u0001\n\u0013\u0001\u00022p_RT!AI\u0012\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001J\u0001\u0004_J<\u0017B\u0001\u0014\u001c\u0005Q!\u0015\r^1T_V\u00148-\u001a)s_B,'\u000f^5fg\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011!D\u0001\u0011W\u0016L8\u000f^8sKB\u000b7o]<pe\u0012,\u0012!\f\t\u0003]]r!aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I:\u0012A\u0002\u001fs_>$hHC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u0003QYW-_:u_J,\u0007+Y:to>\u0014Hm\u0018\u0013fcR\u0011A\b\u0011\t\u0003{yj\u0011aM\u0005\u0003\u007fM\u0012A!\u00168ji\"9\u0011iAA\u0001\u0002\u0004i\u0013a\u0001=%c\u0005\t2.Z=ti>\u0014X\rU1tg^|'\u000f\u001a\u0011)\t\u0011!ej\u0014\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b!\"\u00198o_R\fG/[8o\u0015\tI%*A\u0004gC\u000e$xN]=\u000b\u0005-\u000b\u0013!\u00022fC:\u001c\u0018BA'G\u0005\u00151\u0016\r\\;f\u0003\u00151\u0018\r\\;fC\u0005\u0001\u0016\u0001\t\u0013|e\u0016\u0004xn]5u_JLhf[3zgR|'/\u001a\u0018qCN\u001cxo\u001c:euu\fAc[3zgR|'/\u001a)be\u0016tGOR8mI\u0016\u0014\u0018\u0001G6fsN$xN]3QCJ,g\u000e\u001e$pY\u0012,'o\u0018\u0013fcR\u0011A\b\u0016\u0005\b\u0003\u001a\t\t\u00111\u0001.\u0003UYW-_:u_J,\u0007+\u0019:f]R4u\u000e\u001c3fe\u0002BCa\u0002#O/\u0006\n\u0001,\u0001\u0011%wJ,\u0007o\\:ji>\u0014\u0018PL6fsN$xN]3/Y>\u001c\u0017\r^5p]jj\u0018\u0001\u00053fM\u0006,H\u000e^#oGJL\b\u000f^3s+\u0005Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0011)H/\u001b7\u000b\u0005\u0001\u001c\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\tl&!\u0005)bgN<xN\u001d3F]\u000e\u0014\u0018\u0010\u001d;fe\u0006\tB-\u001a4bk2$XI\\2ssB$XM\u001d\u0011\u0002\u0017M,G\u000fU1tg^|'\u000f\u001a\u000b\u0003y\u0019DQa\u001a\u0006A\u00025\n\u0001\u0002]1tg^|'\u000fZ\u0001\u0017g\u0016$\b+Y:to>\u0014H-\u00134F]\u000e\u0014\u0018\u0010\u001d;fIR\u0011AH\u001b\u0005\u0006O.\u0001\r!\f\u0015\u0005\u00011$X\u000f\u0005\u0002ne6\taN\u0003\u0002pa\u0006Q\u0001O]8qKJ$\u0018.Z:\u000b\u0005E|\u0012aB2p]R,\u0007\u0010^\u0005\u0003g:\u0014qcQ8oM&<WO]1uS>t\u0007K]8qKJ$\u0018.Z:\u0002\rA\u0014XMZ5yC\u00051\u0018A\u0004=me:\"\u0017\r^1t_V\u00148-\u001a\u0015\u0003\u0001a\u0004\"!\u001f?\u000e\u0003iT!aR>\u000b\u0005E\f\u0013BA?{\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"\u0012\u0001a \t\u0004s\u0006\u0005\u0011bAA\u0002u\n9\u0001K]5nCJL\b")
public class DecrypterDataSourceProperties
extends DataSourceProperties {
    @Value(value="${repository.keystore.password:}")
    private String keystorePassword = "";
    @Value(value="${repository.keystore.location:}")
    private String keystoreParentFolder = "";
    private final PasswordEncrypter defaultEncrypter = new PasswordEncrypter(DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);

    public String keystorePassword() {
        return this.keystorePassword;
    }

    public void keystorePassword_$eq(String x$1) {
        this.keystorePassword = x$1;
    }

    public String keystoreParentFolder() {
        return this.keystoreParentFolder;
    }

    public void keystoreParentFolder_$eq(String x$1) {
        this.keystoreParentFolder = x$1;
    }

    public PasswordEncrypter defaultEncrypter() {
        return this.defaultEncrypter;
    }

    public void setPassword(String password) {
        block0: {
            super.setPassword(password);
            if (this.keystoreParentFolder().isEmpty()) break block0;
            this.setPasswordIfEncrypted(password);
        }
    }

    private void setPasswordIfEncrypted(String password) {
        block3: {
            if (this.keystorePassword().isEmpty()) {
                SecretKey key = DeployitKeys.getPasswordEncryptionKey(null, this.keystoreParentFolder());
                PasswordEncrypter.init(key);
            } else {
                String decodedPassword = this.keystorePassword();
                if (this.defaultEncrypter().isEncodedAndDecryptable(this.keystorePassword())) {
                    decodedPassword = this.defaultEncrypter().decrypt(this.keystorePassword());
                }
                SecretKey key = DeployitKeys.getPasswordEncryptionKey(decodedPassword, this.keystoreParentFolder());
                PasswordEncrypter.init(key);
            }
            PasswordEncrypter encrypter = PasswordEncrypter.getInstance();
            if (!encrypter.isEncodedAndDecryptable(password)) break block3;
            super.setPassword(encrypter.decrypt(password));
        }
    }
}

