/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.databasewriter.commands;

import com.xebialabs.xlrelease.databasewriter.service.ConfigurationService;
import com.xebialabs.xlrelease.databasewriter.service.DashboardService;
import com.xebialabs.xlrelease.databasewriter.service.ReleaseExtensionService;
import com.xebialabs.xlrelease.databasewriter.service.ReleaseService;
import com.xebialabs.xlrelease.databasewriter.service.TaskbackupService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ShellComponent
@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00038\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0005\u0003!Q1A\u0005\u0002\tC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\"AA\n\u0001B\u0001B\u0003%\u0011\nC\u0003N\u0001\u0011\u0005a\nC\u0003f\u0001\u0011\u0005a\rC\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBAF\u0001\u0011\u0005\u0011Q\u0012\u0002\u000e'\",G\u000e\\\"p[6\fg\u000eZ:\u000b\u0005M!\u0012\u0001C2p[6\fg\u000eZ:\u000b\u0005U1\u0012A\u00043bi\u0006\u0014\u0017m]3xe&$XM\u001d\u0006\u0003/a\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003%\n\u0001b\u001a:jujdW\rZ\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\u000b\u0002\u000fM,'O^5dK&\u00111\u0007\r\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003=\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\u0013\u0001F2p]\u001aLw-\u001e:bi&|gnU3sm&\u001cW-F\u00018!\ty\u0003(\u0003\u0002:a\t!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\fQcY8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0007%\u0001\teCND'm\\1sIN+'O^5dKV\tQ\b\u0005\u00020}%\u0011q\b\r\u0002\u0011\t\u0006\u001c\bNY8be\u0012\u001cVM\u001d<jG\u0016\f\u0011\u0003Z1tQ\n|\u0017M\u001d3TKJ4\u0018nY3!\u0003E!\u0018m]6CC\u000e\\W\u000f]*feZL7-Z\u000b\u0002\u0007B\u0011q\u0006R\u0005\u0003\u000bB\u0012\u0011\u0003V1tW\n\f7m[;q'\u0016\u0014h/[2f\u0003I!\u0018m]6CC\u000e\\W\u000f]*feZL7-\u001a\u0011\u0002/I,G.Z1tK\u0016CH/\u001a8tS>t7+\u001a:wS\u000e,W#A%\u0011\u0005=R\u0015BA&1\u0005]\u0011V\r\\3bg\u0016,\u0005\u0010^3og&|gnU3sm&\u001cW-\u0001\rsK2,\u0017m]3FqR,gn]5p]N+'O^5dK\u0002\na\u0001P5oSRtDCB(R%N#V\u000b\u0005\u0002Q\u00015\t!\u0003C\u0003-\u0017\u0001\u0007a\u0006C\u00036\u0017\u0001\u0007q\u0007C\u0003<\u0017\u0001\u0007Q\bC\u0003B\u0017\u0001\u00071\tC\u0003H\u0017\u0001\u0007\u0011\n\u000b\u0002\f/B\u0011\u0001lY\u0007\u00023*\u0011!lW\u0001\u000bC:tw\u000e^1uS>t'B\u0001/^\u0003\u001d1\u0017m\u0019;pefT!AX0\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0001\f\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\t\f1a\u001c:h\u0013\t!\u0017LA\u0005BkR|w/\u001b:fI\u0006!!/Z1e)\r9'n\u001e\t\u0003?!L!!\u001b\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006W2\u0001\r\u0001\\\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004\"!\u001c;\u000f\u00059\u0014\bCA8!\u001b\u0005\u0001(BA9\u001d\u0003\u0019a$o\\8u}%\u00111\u000fI\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tA!)\u0001\u0010\u0004a\u0001Y\u0006!a-\u001b7fQ\u0019a!0!\u0002\u0002\bA\u001910!\u0001\u000e\u0003qT!! @\u0002\u0011M$\u0018M\u001c3be\u0012T!a`0\u0002\u000bMDW\r\u001c7\n\u0007\u0005\rAPA\u0006TQ\u0016dG.T3uQ>$\u0017!\u0002<bYV,\u0017EAA\u0005\u00031\u0012V-\u00193tAQDW\r\t:fY\u0016\f7/\u001a\u0011d_:$XM\u001c;!C:$\u0007e\u001d;pe\u0016\u001c\b%\u001b8!M&dW-A\u0003xe&$X\rF\u0003h\u0003\u001f\t\t\u0002C\u0003l\u001b\u0001\u0007A\u000eC\u0003y\u001b\u0001\u0007A\u000e\u000b\u0004\u000eu\u0006\u0015\u0011QC\u0011\u0003\u0003/\tQe\u0015;pe\u0016\u0004C\u000f[3!e\u0016dW-Y:fA\r|g\u000e^3oi\u0002Jg\u000e\t3bi\u0006\u0014\u0017m]3\u0002\u0013\u0005twN\\=nSj,GcB4\u0002\u001e\u0005U\u00121\t\u0005\u0007\u0003?q\u0001\u0019\u00017\u0002\r1|7-\u00197fQ1\ti\"a\t\u0002*\u0005-\u0012qFA\u0019!\rY\u0018QE\u0005\u0004\u0003Oa(aC*iK2dw\n\u001d;j_:\fA\u0001[3ma\u0006\u0012\u0011QF\u00017\u0019>\u001c\u0017\r\\3!i>\u0004#-\u001a\u0011vg\u0016$\u0007EZ8sA\u0005twN\\=nSj\fG/[8oY\u0001*gf\u001a\u0018!EU\u001b&\u0005I8sA\trEJI\u0001\rI\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0003\u0003g\t\u0001bX0O\u001f:+ul\u0018\u0005\u0007\u0003oq\u0001\u0019\u00017\u00025\u0005$G-\u001b;j_:\fGNU3qY\u0006\u001cW-\\3oiN\u0004\u0016\r\u001e5)\u0019\u0005U\u00121EA\u0015\u0003w\ty#a\u0010\"\u0005\u0005u\u0012!a\u001aBAA\fG\u000f\u001b\u0011u_\u0002\n\u0007EZ5mK\u0002:\u0018\u000e\u001e5!C\u0012$\u0017\u000e^5p]\u0006d\u0007e\u001d;sS:<7\u000f\t;iCR\u0004S.^:uA\t,\u0007E]3qY\u0006\u001cW\r\u001a\u0011xSRD\u0007\u0005\u001d7bG\u0016Dw\u000e\u001c3feN\u0004s\u000f[3oA\u0005twN\\=nSjLgn\u001a\u0017!gV\u001c\u0007\u000eI1tA=\u0014x-\u00198ju\u0006$\u0018n\u001c8tA9\fW.Z:/A=sW\rI:ue&tw\r\t9fe\u0002b\u0017N\\3-AI,\u0007\u000f\\1dK6,g\u000e\u001e\u0011jg\u0002\u001a\u0017m]3!g\u0016t7/\u001b;jm\u0016t\u0013EAA!\u0003!yvLT+M\u0019~{\u0006BBA#\u001d\u0001\u0007A.A\fb]>t\u00170\\5{CRLwN\\(viB,H\u000fU1uQ\"b\u00111IA\u0012\u0003S\tI%a\f\u0002@\u0005\u0012\u00111J\u0001l\u0013\u001a\u00043\u000f]3dS\u001aLW\r\u001a\u0011bA5\f\u0007\u000f]5oO\u0002zg\rI1mY\u0002\u0012X\r\u001d7bG\u0016lWM\u001c;tA5\fG-\u001a\u0011ekJLgn\u001a\u0011b]>t\u00170\\5{CRLwN\u001c\u0011xS2d\u0007EY3!oJLG\u000f^3oAQ|\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007EZ5mK:BcA\u0004>\u0002\u0006\u0005=\u0013EAA)\u0003m$&/[3tAQ|\u0007%\u00198p]fl\u0017N_3!e\u0016dW-Y:fg>2\u0018M]5bE2,7oL3uG\u0002\u0012\u0017\u0010\t:f[>4\u0018N\\4!a\u0006\u001c8o^8sIN\u0004\u0013M\u001c3![\u0006\u001c8.\u001b8hA\u0015l\u0017-\u001b7tY\u0001\u0002\bn\u001c8fA9,XNY3sg2\u0002So]3s]\u0006lWm\u001d\u0011b]\u0012\u0004c-\u001e7mA9\fW.Z:\u0002#I,\u0017\rZ0bY2|\u0016M]2iSZ,G\rF\u0007h\u0003/\n\t'a\u001c\u0002t\u0005]\u00141\u0010\u0005\u0007\u00033z\u0001\u0019\u00017\u0002\tA\fG\u000f\u001b\u0015\t\u0003/\n\u0019#!\u000b\u0002^\u0005\u0012\u0011qL\u00015\t&\u0014Xm\u0019;pef\u0004Co\u001c\u0011xQ&\u001c\u0007\u000e\t;iK\u0002R5k\u0014(!M&dWm\u001d\u0011xS2d\u0007EY3!I><h\u000e\\8bI\u0016$\u0007bBA\r\u001f\u0001\u0007\u00111\r\t\u0004?\u0005\u0015\u0014bAA4A\t9!i\\8mK\u0006t\u0007\u0006CA1\u0003G\tI#a\u001b\"\u0005\u00055\u0014!!\u001fJM\u0002\u001a\b/Z2jM&,G\r\t;iK\u0002\"\u0017\r^1!o&dG\u000e\t2fA\u0005twN\\=nSj,GM\u000f\u0011f[\u0006LGn\u001d\u0017!a\"|g.\u001a\u0011ok6\u0014WM]:-AU\u001cXM\u001d8b[\u0016\u001c\b%\u00198eA!Jg\rI1wC&d\u0017M\u00197fS\u00012W\u000f\u001c7!]\u0006lWm\u001d\u0011xS2d\u0007EY3!e\u0016\u0004H.Y2fI\u0002Jg\u000e\t;iK\u0002\u0012X\r\\3bg\u0016\u001cx\u0005I2p]R,g\u000e^:/A9{G/\u001a\u0011uQ\u0006$\b%\u00198p]fl\u0017N_1uS>t\u0007eY1oAQ\f7.\u001a\u0011i_V\u00148O\f\u0005\u0007\u0003?y\u0001\u0019\u00017)\u0019\u0005=\u00141EA\u0015\u0003W\ty#a\u0010\t\r\u0005]r\u00021\u0001mQ1\t\u0019(a\t\u0002*\u0005m\u0012qFA \u0011\u0019\t)e\u0004a\u0001Y\"b\u0011qOA\u0012\u0003S\tI%a\f\u0002@!9\u0011QP\bA\u0002\u0005\r\u0014\u0001D:lSB,\u00050[:uS:<\u0007\u0006CA>\u0003G\tI#!!\"\u0005\u0005\r\u0015AO*lSB\u0004#/\u001a7fCN,7\u000f\t;iCR\u0004s/\u001a:fA\u0005d'/Z1es\u0002\ngn\u001c8z[&TX\r\u001a\u0011b]\u0012\u0004Cm\\<oY>\fG-\u001a3/Q\u0019y!0!\u0002\u0002\b\u0006\u0012\u0011\u0011R\u0001\u0002>I+\u0017\rZ:!C2d\u0007%\u0019:dQ&4X\r\u001a\u0011sK2,\u0017m]3tA%tGo\u001c\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"\u0017N]3di>\u0014\u0018\u0010\f\u0011xSRD\u0007e\u001c9uS>t\u0017\r\u001c\u0011b]>t\u00170\\5{CRLwN\u001c\u0018!%\u0016dW-Y:fA\u0019LG.\u001a\u0011oC6,7\u000fI1sK\u0002ZFH]3mK\u0006\u001cXmX5e}9R7o\u001c8^A\u0005tG\r\t4pY2|w\u000f\t;iK\u00022w\u000e\u001c3fe\u0002\u001aHO];diV\u0014XML\u0001\bK:\u001c'/\u001f9u)\u00059\u0007F\u0002\t{\u0003\u000b\t\t*\t\u0002\u0002\u0014\u00069UI\\2ssB$8\u000fI1mY\u0002\u0002\u0018m]:x_J$7\u000f\t4s_6\u0004\u0013m\u0019;jm\u0016\u0004#/\u001a7fCN,7\u000fI1oI\u0002\u001awN\u001c4jOV\u0014\u0018\r^5p]N\u0004s/\u001b;iA\u0005+5\u000bK\u0002\u0001\u0003/\u00032a_AM\u0013\r\tY\n \u0002\u000f'\",G\u000e\\\"p[B|g.\u001a8u\u0001")
public class ShellCommands
implements Logging {
    private final ReleaseService releaseService;
    private final ConfigurationService configurationService;
    private final DashboardService dashboardService;
    private final TaskbackupService taskBackupService;
    private final ReleaseExtensionService releaseExtensionService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ShellCommands shellCommands = this;
        synchronized (shellCommands) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ConfigurationService configurationService() {
        return this.configurationService;
    }

    public DashboardService dashboardService() {
        return this.dashboardService;
    }

    public TaskbackupService taskBackupService() {
        return this.taskBackupService;
    }

    public ReleaseExtensionService releaseExtensionService() {
        return this.releaseExtensionService;
    }

    @ShellMethod(value="Reads the release content and stores in file")
    public void read(String releaseId, String file) {
        this.releaseService().readRelease(releaseId, file);
    }

    @ShellMethod(value="Store the release content in database")
    public void write(String releaseId, String file) {
        this.releaseService().writeRelease(releaseId, file);
    }

    @ShellMethod(value="Tries to anonymize releases/variables/etc by removing passwords and masking emails, phone numbers, usernames and full names")
    public void anonymize(@ShellOption(help="Locale to be used for anonymization, e.g. \"US\" or \"NL\"", defaultValue="__NONE__") String locale, @ShellOption(help="A path to a file with additional strings that must be replaced with placeholders when anonymizing, such as organizations names. One string per line, replacement is case sensitive.", defaultValue="__NULL__") String additionalReplacementsPath, @ShellOption(help="If specified a mapping of all replacements made during anonymization will be written to the specified file.", defaultValue="__NULL__") String anonymizationOutputPath) {
        this.configurationService().restoreDefaultAdmin();
        this.releaseService().anonReleases(locale, additionalReplacementsPath, anonymizationOutputPath);
        this.configurationService().anonConfigurations(locale, additionalReplacementsPath, anonymizationOutputPath);
    }

    @ShellMethod(value="Reads all archived releases into specified directory, with optional anonymization. Release file names are [<release_id>.json] and follow the folder structure.")
    public void read_all_archived(@ShellOption(help="Directory to which the JSON files will be downloaded") String path, @ShellOption(help="If specified the data will be anonymized: emails, phone numbers, usernames and (if available) full names will be replaced in the releases' contents. Note that anonymization can take hours.") boolean anonymize, @ShellOption(help="Locale to be used for anonymization, e.g. \"US\" or \"NL\"", defaultValue="__NULL__") String locale, @ShellOption(help="A path to a file with additional strings that must be replaced with placeholders when anonymizing, such as organizations names. One string per line, replacement is case sensitive.", defaultValue="__NULL__") String additionalReplacementsPath, @ShellOption(help="If specified a mapping of all replacements made during anonymization will be written to the specified file.", defaultValue="__NULL__") String anonymizationOutputPath, @ShellOption(help="Skip releases that were already anonymized and downloaded.") boolean skipExisting) {
        if (anonymize && locale == null) {
            this.logger().error((Function0 & Serializable)() -> "[--locale] must be specified if anonymization was requested");
            return;
        }
        this.releaseService().readAllArchived(path, anonymize, locale, additionalReplacementsPath, anonymizationOutputPath, skipExisting);
    }

    @ShellMethod(value="Encrypts all passwords from active releases and configurations with AES")
    public void encrypt() {
        this.releaseService().encryptReleases();
        this.configurationService().encryptConfigurations();
        this.dashboardService().encryptDashboards();
        this.taskBackupService().encryptTaskbackups();
        this.releaseExtensionService().encryptReleaseExtensions();
    }

    @Autowired
    public ShellCommands(ReleaseService releaseService, ConfigurationService configurationService, DashboardService dashboardService, TaskbackupService taskBackupService, ReleaseExtensionService releaseExtensionService) {
        this.releaseService = releaseService;
        this.configurationService = configurationService;
        this.dashboardService = dashboardService;
        this.taskBackupService = taskBackupService;
        this.releaseExtensionService = releaseExtensionService;
        Logging.$init$((Logging)this);
    }
}

