/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.config.UserConfigPathProvider;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class UserConfigAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={UserConfigPathProvider.class})
    public UserConfigPathProvider userConfigPathProvider(SpringShellProperties springShellProperties) {
        return () -> {
            LocationResolver resolver = new LocationResolver(springShellProperties.getConfig().getEnv(), springShellProperties.getConfig().getLocation());
            return resolver.resolve();
        };
    }

    static class LocationResolver {
        private static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
        private static final String APP_DATA = "APP_DATA";
        private static final String USERCONFIG_PLACEHOLDER = "{userconfig}";
        private Function<String, Path> pathProvider = path -> Paths.get(path, new String[0]);
        private final String configDirEnv;
        private final String configDirLocation;

        LocationResolver(String configDirEnv, String configDirLocation) {
            this.configDirEnv = configDirEnv;
            this.configDirLocation = configDirLocation;
        }

        Path resolve() {
            String location = StringUtils.hasText((String)this.configDirEnv) && StringUtils.hasText((String)System.getenv(this.configDirEnv)) ? System.getenv(this.configDirEnv) : (StringUtils.hasText((String)this.configDirLocation) ? this.configDirLocation : "");
            if (this.usesUserConfigLocation(location)) {
                location = this.resolveUserConfigLocation(location);
            }
            return this.pathProvider.apply(location);
        }

        private boolean usesUserConfigLocation(String location) {
            return location.contains(USERCONFIG_PLACEHOLDER);
        }

        private String resolveUserConfigLocation(String location) {
            String userConfigHome = "";
            userConfigHome = StringUtils.hasText((String)System.getenv(XDG_CONFIG_HOME)) ? System.getenv(XDG_CONFIG_HOME) : (this.isWindows() && StringUtils.hasText((String)System.getenv(APP_DATA)) ? System.getenv(APP_DATA) : System.getProperty("user.home") + "/.config");
            return location.replace(USERCONFIG_PLACEHOLDER, userConfigHome);
        }

        private boolean isWindows() {
            String os = System.getProperty("os.name");
            return os.startsWith("Windows");
        }
    }
}

