/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

public abstract class FigureSettings {
    public static final String TAG_TICK = "tick";
    public static final String TAG_INFO = "info";
    public static final String TAG_WARNING = "warning";
    public static final String TAG_ERROR = "error";
    public static final String TAG_CHECKBOX_OFF = "checkboxOff";
    public static final String TAG_CHECKBOX_ON = "checkboxOn";
    public static final String TAG_LEFTWARDS_ARROR = "leftwardsArrow";
    public static final String TAG_UPWARDS_ARROR = "upwardsArrow";
    public static final String TAG_RIGHTWARDS_ARROR = "righwardsArror";
    public static final String TAG_DOWNWARDS_ARROR = "downwardsArror";
    public static final String TAG_LEFT_POINTING_QUOTATION = "leftPointingQuotation";
    public static final String TAG_RIGHT_POINTING_QUOTATION = "rightPointingQuotation";
    public static final String TAG_QUESTION_MARK = "questionMark";

    public String tick() {
        return "\u2714";
    }

    public String info() {
        return "\u2139";
    }

    public String warning() {
        return "\u26a0";
    }

    public String error() {
        return "\u2716";
    }

    public String checkboxOff() {
        return "\u2610";
    }

    public String checkboxOn() {
        return "\u2612";
    }

    public String leftwardsArrow() {
        return "\u2190";
    }

    public String upwardsArrow() {
        return "\u2191";
    }

    public String righwardsArror() {
        return "\u2192";
    }

    public String downwardsArror() {
        return "\u2193";
    }

    public String leftPointingQuotation() {
        return "\u276e";
    }

    public String rightPointingQuotation() {
        return "\u276f";
    }

    public String questionMark() {
        return "?";
    }

    public String resolveTag(String tag) {
        switch (tag) {
            case "tick": {
                return this.tick();
            }
            case "info": {
                return this.info();
            }
            case "warning": {
                return this.warning();
            }
            case "error": {
                return this.error();
            }
            case "checkboxOff": {
                return this.checkboxOff();
            }
            case "checkboxOn": {
                return this.checkboxOn();
            }
            case "leftwardsArrow": {
                return this.leftwardsArrow();
            }
            case "upwardsArrow": {
                return this.upwardsArrow();
            }
            case "righwardsArror": {
                return this.righwardsArror();
            }
            case "downwardsArror": {
                return this.downwardsArror();
            }
            case "leftPointingQuotation": {
                return this.leftPointingQuotation();
            }
            case "rightPointingQuotation": {
                return this.rightPointingQuotation();
            }
            case "questionMark": {
                return this.questionMark();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown tag '%s'", tag));
    }

    public static FigureSettings defaults() {
        return new DefaultFigureSettings();
    }

    public static FigureSettings dump() {
        return new DumpFigureSettings();
    }

    public static String[] tags() {
        return new String[]{TAG_TICK, TAG_INFO, TAG_WARNING, TAG_ERROR, TAG_CHECKBOX_OFF, TAG_CHECKBOX_ON, TAG_LEFTWARDS_ARROR, TAG_UPWARDS_ARROR, TAG_RIGHTWARDS_ARROR, TAG_DOWNWARDS_ARROR, TAG_LEFT_POINTING_QUOTATION, TAG_RIGHT_POINTING_QUOTATION, TAG_QUESTION_MARK};
    }

    private static class DumpFigureSettings
    extends FigureSettings {
        private DumpFigureSettings() {
        }

        @Override
        public String tick() {
            return "v";
        }

        @Override
        public String info() {
            return "i";
        }

        @Override
        public String warning() {
            return "!";
        }

        @Override
        public String error() {
            return "x";
        }

        @Override
        public String checkboxOff() {
            return "[ ]";
        }

        @Override
        public String checkboxOn() {
            return "[x]";
        }

        @Override
        public String leftwardsArrow() {
            return "<";
        }

        @Override
        public String upwardsArrow() {
            return "^";
        }

        @Override
        public String righwardsArror() {
            return ">";
        }

        @Override
        public String downwardsArror() {
            return "v";
        }

        @Override
        public String leftPointingQuotation() {
            return "<";
        }

        @Override
        public String rightPointingQuotation() {
            return ">";
        }
    }

    private static class DefaultFigureSettings
    extends FigureSettings {
        private DefaultFigureSettings() {
        }
    }
}

