/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.context;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.springframework.shell.component.context.ComponentContext;

public class BaseComponentContext<C extends ComponentContext<C>>
extends LinkedHashMap<Object, Object>
implements ComponentContext<C> {
    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (o != null) {
            return o;
        }
        throw new NoSuchElementException("Context does not contain key: " + key);
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.get(key);
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for key '" + key + "'. Expected [" + type + "] but actual type is [" + value.getClass() + "]");
        }
        return (T)value;
    }

    @Override
    public ComponentContext<C> put(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    @Override
    public Stream<Map.Entry<Object, Object>> stream() {
        return this.entrySet().stream();
    }

    @Override
    public Map<String, Object> toTemplateModel() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("rawValues", this);
        return attributes;
    }
}

