/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractTextComponent;
import org.springframework.util.StringUtils;

public class StringInput
extends AbstractTextComponent<String, StringInputContext> {
    private static final Logger log = LoggerFactory.getLogger(StringInput.class);
    private final String defaultValue;
    private StringInputContext currentContext;
    private Character maskCharacter;

    public StringInput(Terminal terminal) {
        this(terminal, null, null, null);
    }

    public StringInput(Terminal terminal, String name, String defaultValue) {
        this(terminal, name, defaultValue, null);
    }

    public StringInput(Terminal terminal, String name, String defaultValue, Function<StringInputContext, List<AttributedString>> renderer) {
        super(terminal, name, null);
        this.setRenderer(renderer != null ? renderer : new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/string-input-default.stg");
        this.defaultValue = defaultValue;
    }

    public void setMaskCharater(Character maskCharacter) {
        this.maskCharacter = maskCharacter;
    }

    @Override
    public StringInputContext getThisContext(ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = StringInputContext.of(this.defaultValue, this.maskCharacter);
        this.currentContext.setName(this.getName());
        context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        return this.currentContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, StringInputContext context) {
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug("Binding read result {}", (Object)operation);
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                String input = context.getInput();
                input = input == null ? lastBinding : input + lastBinding;
                context.setInput(input);
                break;
            }
            case "BACKSPACE": {
                String input = context.getInput();
                if (StringUtils.hasLength((String)input)) {
                    input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                context.setInput(input);
                break;
            }
            case "EXIT": {
                if (StringUtils.hasText((String)context.getInput())) {
                    context.setResultValue(context.getInput());
                } else if (context.getDefaultValue() != null) {
                    context.setResultValue(context.getDefaultValue());
                }
                return true;
            }
        }
        return false;
    }

    private class DefaultRenderer
    implements Function<StringInputContext, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(StringInputContext context) {
            return StringInput.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    private static class DefaultStringInputContext
    extends AbstractTextComponent.BaseTextComponentContext<String, StringInputContext>
    implements StringInputContext {
        private String defaultValue;
        private Character maskCharacter;

        public DefaultStringInputContext(String defaultValue, Character maskCharacter) {
            this.defaultValue = defaultValue;
            this.maskCharacter = maskCharacter;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void setMaskCharacter(Character maskCharacter) {
            this.maskCharacter = maskCharacter;
        }

        @Override
        public String getMaskedInput() {
            return this.maybeMask(this.getInput());
        }

        @Override
        public String getMaskedResultValue() {
            return this.maybeMask((String)this.getResultValue());
        }

        @Override
        public boolean hasMaskCharacter() {
            return this.maskCharacter != null;
        }

        @Override
        public Character getMaskCharacter() {
            return this.maskCharacter;
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            attributes.put("defaultValue", this.getDefaultValue() != null ? this.getDefaultValue() : null);
            attributes.put("maskedInput", this.getMaskedInput());
            attributes.put("maskedResultValue", this.getMaskedResultValue());
            attributes.put("maskCharacter", this.getMaskCharacter());
            attributes.put("hasMaskCharacter", this.hasMaskCharacter());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }

        private String maybeMask(String str) {
            if (StringUtils.hasLength((String)str) && this.maskCharacter != null) {
                return new String(new char[str.length()]).replace('\u0000', this.maskCharacter.charValue());
            }
            return str;
        }
    }

    public static interface StringInputContext
    extends AbstractTextComponent.TextComponentContext<String, StringInputContext> {
        public String getDefaultValue();

        public void setDefaultValue(String var1);

        public void setMaskCharacter(Character var1);

        public String getMaskedInput();

        public String getMaskedResultValue();

        public boolean hasMaskCharacter();

        public Character getMaskCharacter();

        public static StringInputContext empty() {
            return StringInputContext.of(null, null);
        }

        public static StringInputContext of(String defaultValue, Character maskCharacter) {
            return new DefaultStringInputContext(defaultValue, maskCharacter);
        }
    }
}

