/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Validator;
import org.jline.terminal.Terminal;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.shell.Availability;
import org.springframework.shell.CommandNotCurrentlyAvailable;
import org.springframework.shell.command.CommandContext;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.command.CommandParser;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.invocation.InvocableShellMethod;
import org.springframework.shell.command.invocation.ShellMethodArgumentResolverComposite;

public interface CommandExecution {
    public Object evaluate(CommandRegistration var1, String[] var2);

    public static CommandExecution of(List<? extends HandlerMethodArgumentResolver> resolvers) {
        return new DefaultCommandExecution(resolvers, null, null, null);
    }

    public static CommandExecution of(List<? extends HandlerMethodArgumentResolver> resolvers, Validator validator, Terminal terminal, ConversionService conversionService) {
        return new DefaultCommandExecution(resolvers, validator, terminal, conversionService);
    }

    public static class CommandExecutionHandlerMethodArgumentResolvers {
        private final List<? extends HandlerMethodArgumentResolver> resolvers;

        public CommandExecutionHandlerMethodArgumentResolvers(List<? extends HandlerMethodArgumentResolver> resolvers) {
            this.resolvers = resolvers;
        }

        public List<? extends HandlerMethodArgumentResolver> getResolvers() {
            return this.resolvers;
        }
    }

    public static class CommandParserExceptionsException
    extends RuntimeException {
        private final List<CommandParser.CommandParserException> parserExceptions;

        public CommandParserExceptionsException(String message, List<CommandParser.CommandParserException> parserExceptions) {
            super(message);
            this.parserExceptions = parserExceptions;
        }

        public static CommandParserExceptionsException of(String message, List<CommandParser.CommandParserException> parserExceptions) {
            return new CommandParserExceptionsException(message, parserExceptions);
        }

        public List<CommandParser.CommandParserException> getParserExceptions() {
            return this.parserExceptions;
        }
    }

    public static class CommandExecutionException
    extends RuntimeException {
        public CommandExecutionException(Throwable cause) {
            super(cause);
        }
    }

    @Order(value=100)
    public static class ParamNameHandlerMethodArgumentResolver
    implements HandlerMethodArgumentResolver {
        private final Map<String, Object> paramValues = new HashMap<String, Object>();
        private final ConversionService conversionService;

        ParamNameHandlerMethodArgumentResolver(Map<String, Object> paramValues, ConversionService conversionService) {
            this.paramValues.putAll(paramValues);
            this.conversionService = conversionService;
        }

        public boolean supportsParameter(MethodParameter parameter) {
            String parameterName = parameter.getParameterName();
            if (parameterName == null) {
                return false;
            }
            return this.paramValues.containsKey(parameterName) && this.conversionService.canConvert(this.paramValues.get(parameterName).getClass(), parameter.getParameterType());
        }

        public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
            return this.conversionService.convert(this.paramValues.get(parameter.getParameterName()), parameter.getParameterType());
        }
    }

    public static class DefaultCommandExecution
    implements CommandExecution {
        private List<? extends HandlerMethodArgumentResolver> resolvers;
        private Validator validator;
        private Terminal terminal;
        private ConversionService conversionService;

        public DefaultCommandExecution(List<? extends HandlerMethodArgumentResolver> resolvers, Validator validator, Terminal terminal, ConversionService conversionService) {
            this.resolvers = resolvers;
            this.validator = validator;
            this.terminal = terminal;
            this.conversionService = conversionService;
        }

        @Override
        public Object evaluate(CommandRegistration registration, String[] args) {
            Availability availability = registration.getAvailability();
            if (availability != null && !availability.isAvailable()) {
                return new CommandNotCurrentlyAvailable(registration.getCommand(), availability);
            }
            List<CommandOption> options = registration.getOptions();
            CommandParser parser = CommandParser.of(this.conversionService);
            CommandParser.CommandParserResults results = parser.parse(options, args);
            if (!results.errors().isEmpty()) {
                throw new CommandParserExceptionsException("Command parser resulted errors", results.errors());
            }
            CommandContext ctx = CommandContext.of(args, results, this.terminal, registration);
            Object res = null;
            CommandRegistration.TargetInfo targetInfo = registration.getTarget();
            if (targetInfo.getTargetType() == CommandRegistration.TargetInfo.TargetType.FUNCTION) {
                res = targetInfo.getFunction().apply(ctx);
            } else if (targetInfo.getTargetType() == CommandRegistration.TargetInfo.TargetType.CONSUMER) {
                targetInfo.getConsumer().accept(ctx);
            } else if (targetInfo.getTargetType() == CommandRegistration.TargetInfo.TargetType.METHOD) {
                try {
                    MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)args);
                    HashMap<String, Object> paramValues = new HashMap<String, Object>();
                    results.results().stream().forEach(r -> {
                        if (r.option().getLongNames() != null) {
                            for (String string : r.option().getLongNames()) {
                                messageBuilder.setHeader("springShellArgument." + (String)string, r.value());
                                paramValues.put(string, r.value());
                            }
                        }
                        if (r.option().getShortNames() != null) {
                            for (Character c : r.option().getShortNames()) {
                                messageBuilder.setHeader("springShellArgument." + c.toString(), r.value());
                            }
                        }
                    });
                    messageBuilder.setHeader("springShellCommandContext", (Object)ctx);
                    InvocableShellMethod invocableShellMethod = new InvocableShellMethod(targetInfo.getBean(), targetInfo.getMethod());
                    invocableShellMethod.setConversionService(this.conversionService);
                    invocableShellMethod.setValidator(this.validator);
                    ShellMethodArgumentResolverComposite argumentResolvers = new ShellMethodArgumentResolverComposite();
                    if (this.resolvers != null) {
                        argumentResolvers.addResolvers(this.resolvers);
                    }
                    if (!paramValues.isEmpty()) {
                        argumentResolvers.addResolver(new ParamNameHandlerMethodArgumentResolver(paramValues, this.conversionService));
                    }
                    invocableShellMethod.setMessageMethodArgumentResolvers(argumentResolvers);
                    res = invocableShellMethod.invoke(messageBuilder.build(), null);
                }
                catch (Exception e) {
                    throw new CommandExecutionException(e);
                }
            }
            return res;
        }
    }
}

