/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;

public class Utils {
    private static final ValidatorFactory DEFAULT_VALIDATOR_FACTORY = Validation.buildDefaultValidatorFactory();
    private static final Validator DEFAULT_VALIDATOR = DEFAULT_VALIDATOR_FACTORY.getValidator();

    public static String unCamelify(CharSequence original) {
        StringBuilder result = new StringBuilder(original.length());
        boolean wasLowercase = false;
        for (int i = 0; i < original.length(); ++i) {
            char ch = original.charAt(i);
            if (Character.isUpperCase(ch) && wasLowercase) {
                result.append('-');
            }
            wasLowercase = Character.isLowerCase(ch);
            result.append(Character.toLowerCase(ch));
        }
        return result.toString();
    }

    public static MethodParameter createMethodParameter(Parameter parameter) {
        Parameter[] parameters = parameter.getDeclaringExecutable().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(parameter)) continue;
            return Utils.createMethodParameter(parameter.getDeclaringExecutable(), i);
        }
        throw new AssertionError((Object)"Can't happen");
    }

    public static MethodParameter createMethodParameter(Executable executable, int i) {
        MethodParameter methodParameter;
        if (executable instanceof Method) {
            methodParameter = new MethodParameter((Method)executable, i);
        } else if (executable instanceof Constructor) {
            methodParameter = new MethodParameter((Constructor)executable, i);
        } else {
            throw new IllegalArgumentException("Unsupported Executable: " + executable);
        }
        methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
        return methodParameter;
    }

    public static Stream<MethodParameter> createMethodParameters(Executable executable) {
        return IntStream.range(0, executable.getParameterCount()).mapToObj(i -> Utils.createMethodParameter(executable, i));
    }

    public static List<String> sanitizeInput(List<String> words) {
        words = words.stream().map(s -> s.replaceAll("^\\n+|\\n+$", "")).map(s -> s.replaceAll("\\n+", " ")).collect(Collectors.toList());
        return words;
    }

    public static ValidatorFactory defaultValidatorFactory() {
        return DEFAULT_VALIDATOR_FACTORY;
    }

    public static Validator defaultValidator() {
        return DEFAULT_VALIDATOR;
    }

    public static <T> List<List<T>> split(T[] array, Predicate<T> predicate) {
        List<T> list = Arrays.asList(array);
        boolean[] boundaries = new boolean[array.length];
        ArrayList<List<T>> split = new ArrayList<List<T>>();
        for (int i = 0; i < array.length; ++i) {
            boundaries[i] = predicate.test(array[i]);
        }
        int tail = 0;
        for (int i = 0; i < boundaries.length; ++i) {
            if (!boundaries[i]) continue;
            if (tail < i) {
                split.add(list.subList(tail, i));
            }
            tail = i;
        }
        if (tail < array.length) {
            split.add(list.subList(tail, array.length));
        }
        return split;
    }
}

