/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.lang.reflect.UndeclaredThrowableException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jline.terminal.Terminal;
import org.jline.utils.Signals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.shell.CommandNotFound;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.ExitRequest;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.ResultHandlerService;
import org.springframework.shell.Utils;
import org.springframework.shell.command.CommandAlias;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.command.CommandExecution;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.completion.CompletionResolver;
import org.springframework.shell.context.InteractionMode;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.exit.ExitCodeMappings;
import org.springframework.util.StringUtils;

public class Shell {
    private static final Logger log = LoggerFactory.getLogger(Shell.class);
    private final ResultHandlerService resultHandlerService;
    public static final Object NO_INPUT = new Object();
    private final Terminal terminal;
    private final CommandCatalog commandRegistry;
    protected List<CompletionResolver> completionResolvers = new ArrayList<CompletionResolver>();
    private CommandExecution.CommandExecutionHandlerMethodArgumentResolvers argumentResolvers;
    private ConversionService conversionService = new DefaultConversionService();
    private final ShellContext shellContext;
    private final ExitCodeMappings exitCodeMappings;
    protected static final Object UNRESOLVED = new Object();
    private Validator validator = Utils.defaultValidator();

    public Shell(ResultHandlerService resultHandlerService, CommandCatalog commandRegistry, Terminal terminal, ShellContext shellContext, ExitCodeMappings exitCodeMappings) {
        this.resultHandlerService = resultHandlerService;
        this.commandRegistry = commandRegistry;
        this.terminal = terminal;
        this.shellContext = shellContext;
        this.exitCodeMappings = exitCodeMappings;
    }

    @Autowired
    public void setCompletionResolvers(List<CompletionResolver> resolvers) {
        this.completionResolvers = new ArrayList<CompletionResolver>(resolvers);
        AnnotationAwareOrderComparator.sort(this.completionResolvers);
    }

    @Autowired
    public void setArgumentResolvers(CommandExecution.CommandExecutionHandlerMethodArgumentResolvers argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setConversionService(ConversionService shellConversionService) {
        this.conversionService = shellConversionService;
    }

    @Autowired(required=false)
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public void run(InputProvider inputProvider) throws Exception {
        Object result = null;
        while (!(result instanceof ExitRequest)) {
            Input input;
            try {
                input = inputProvider.readInput();
            }
            catch (Exception e) {
                if (e instanceof ExitRequest) break;
                this.resultHandlerService.handle(e);
                continue;
            }
            if (input == null) break;
            result = this.evaluate(input);
            if (result != NO_INPUT && !(result instanceof ExitRequest)) {
                this.resultHandlerService.handle(result);
            }
            if (this.shellContext == null || this.shellContext.getInteractionMode() == InteractionMode.INTERACTIVE) continue;
            if (result instanceof CommandExecution.CommandParserExceptionsException) {
                throw (CommandExecution.CommandParserExceptionsException)result;
            }
            if (!(result instanceof Exception)) continue;
            throw (Exception)result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Input input) {
        if (this.noInput(input)) {
            return NO_INPUT;
        }
        String line = input.words().stream().collect(Collectors.joining(" ")).trim();
        String command = this.findLongestCommand(line);
        List<String> words = input.words();
        log.debug("Evaluate input with line=[{}], command=[{}]", (Object)line, (Object)command);
        if (command != null) {
            Optional<CommandRegistration> commandRegistration = this.commandRegistry.getRegistrations().values().stream().filter(r -> {
                if (r.getCommand().equals(command)) {
                    return true;
                }
                for (CommandAlias a : r.getAliases()) {
                    if (!a.getCommand().equals(command)) continue;
                    return true;
                }
                return false;
            }).findFirst();
            if (commandRegistration.isPresent()) {
                if (this.exitCodeMappings != null) {
                    List<Function<Throwable, Integer>> mappingFunctions = commandRegistration.get().getExitCode().getMappingFunctions();
                    this.exitCodeMappings.reset(mappingFunctions);
                }
                List<String> wordsForArgs = this.wordsForArguments(command, words);
                Thread commandThread = Thread.currentThread();
                Object sh = Signals.register((String)"INT", () -> commandThread.interrupt());
                try {
                    CommandExecution execution = CommandExecution.of(this.argumentResolvers != null ? this.argumentResolvers.getResolvers() : null, this.validator, this.terminal, this.conversionService);
                    Object object = execution.evaluate(commandRegistration.get(), wordsForArgs.toArray(new String[0]));
                    return object;
                }
                catch (UndeclaredThrowableException e) {
                    if (e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException) {
                        Thread.interrupted();
                    }
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                catch (CommandExecution.CommandExecutionException e) {
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                catch (Exception e) {
                    Exception exception = e;
                    return exception;
                }
                finally {
                    Signals.unregister((String)"INT", (Object)sh);
                }
            }
            return new CommandNotFound(words);
        }
        return new CommandNotFound(words);
    }

    private boolean noInput(Input input) {
        return input.words().isEmpty() || input.words().size() == 1 && input.words().get(0).trim().isEmpty() || input.words().iterator().next().matches("\\s*//.*");
    }

    private List<String> wordsForArguments(String command, List<String> words) {
        int wordsUsedForCommandKey = command.split(" ").length;
        List<String> args = words.subList(wordsUsedForCommandKey, words.size());
        int last = args.size() - 1;
        if (last >= 0 && "".equals(args.get(last))) {
            args.remove(last);
        }
        return args;
    }

    public List<CompletionProposal> complete(CompletionContext context) {
        String prefix = context.upToCursor();
        ArrayList<CompletionProposal> candidates = new ArrayList<CompletionProposal>();
        candidates.addAll(this.commandsStartingWith(prefix));
        String best = this.findLongestCommand(prefix);
        if (best != null) {
            context = context.drop(best.split(" ").length);
            CommandRegistration registration = this.commandRegistry.getRegistrations().get(best);
            CompletionContext argsContext = context.commandRegistration(registration);
            for (CompletionResolver resolver : this.completionResolvers) {
                List resolved = (List)resolver.apply(argsContext);
                candidates.addAll(resolved);
            }
            ArrayList<CommandOption> matchedArgOptions = new ArrayList<CommandOption>();
            if (argsContext.getWords().size() > 0 && argsContext.getWordIndex() > 0 && argsContext.getWords().size() > argsContext.getWordIndex()) {
                matchedArgOptions.addAll(this.matchOptions(registration.getOptions(), argsContext.getWords().get(argsContext.getWordIndex() - 1)));
            }
            List argProposals = matchedArgOptions.stream().flatMap(o -> {
                CompletionResolver completion = o.getCompletion();
                if (completion != null) {
                    List apply = (List)completion.apply(argsContext.commandOption((CommandOption)o));
                    return apply.stream();
                }
                return Stream.empty();
            }).collect(Collectors.toList());
            candidates.addAll(argProposals);
        }
        return candidates;
    }

    private List<CommandOption> matchOptions(List<CommandOption> options, String arg) {
        ArrayList<CommandOption> matched = new ArrayList<CommandOption>();
        String trimmed = StringUtils.trimLeadingCharacter((String)arg, (char)'-');
        int count = arg.length() - trimmed.length();
        if (count == 1) {
            if (trimmed.length() == 1) {
                Character trimmedChar = Character.valueOf(trimmed.charAt(0));
                options.stream().filter(o -> {
                    for (Character sn : o.getShortNames()) {
                        if (!trimmedChar.equals(sn)) continue;
                        return true;
                    }
                    return false;
                }).findFirst().ifPresent(o -> matched.add((CommandOption)o));
            } else if (trimmed.length() > 1) {
                trimmed.chars().mapToObj(i -> Character.valueOf((char)i)).forEach(c -> options.stream().forEach(o -> {
                    for (Character sn : o.getShortNames()) {
                        if (!c.equals(sn)) continue;
                        matched.add((CommandOption)o);
                    }
                }));
            }
        } else if (count == 2) {
            options.stream().filter(o -> {
                for (String ln : o.getLongNames()) {
                    if (!trimmed.equals(ln)) continue;
                    return true;
                }
                return false;
            }).findFirst().ifPresent(o -> matched.add((CommandOption)o));
        }
        return matched;
    }

    private List<CompletionProposal> commandsStartingWith(String prefix) {
        int lastWordStart = prefix.lastIndexOf(32) + 1;
        return this.commandRegistry.getRegistrations().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).map(e -> {
            String c = (String)e.getKey();
            c = c.substring(lastWordStart);
            return this.toCommandProposal(c, (CommandRegistration)e.getValue());
        }).collect(Collectors.toList());
    }

    private CompletionProposal toCommandProposal(String command, CommandRegistration registration) {
        return new CompletionProposal(command).dontQuote(true).category("Available commands").description(registration.getDescription());
    }

    private String findLongestCommand(String prefix) {
        String result = this.commandRegistry.getRegistrations().keySet().stream().filter(command -> prefix.equals(command) || prefix.startsWith(command + " ")).reduce("", (c1, c2) -> c1.length() > c2.length() ? c1 : c2);
        return "".equals(result) ? null : result;
    }
}

