/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.standard.ValueProvider;

public class EnumValueProvider
implements ValueProvider {
    @Override
    public boolean supports(MethodParameter parameter, CompletionContext completionContext) {
        return Enum.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public List<CompletionProposal> complete(MethodParameter parameter, CompletionContext completionContext, String[] hints) {
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        for (Object v : parameter.getParameterType().getEnumConstants()) {
            Enum e = (Enum)v;
            String prefix = completionContext.currentWordUpToCursor();
            if (prefix == null) {
                prefix = "";
            }
            if (!e.name().startsWith(prefix)) continue;
            result.add(new CompletionProposal(e.name()));
        }
        return result;
    }
}

