/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;

public class Utils {
    public static String unCamelify(CharSequence original) {
        StringBuilder result = new StringBuilder(original.length());
        boolean wasLowercase = false;
        for (int i = 0; i < original.length(); ++i) {
            char ch = original.charAt(i);
            if (Character.isUpperCase(ch) && wasLowercase) {
                result.append('-');
            }
            wasLowercase = Character.isLowerCase(ch);
            result.append(Character.toLowerCase(ch));
        }
        return result.toString();
    }

    public static MethodParameter createMethodParameter(Parameter parameter) {
        Parameter[] parameters = parameter.getDeclaringExecutable().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(parameter)) continue;
            return Utils.createMethodParameter(parameter.getDeclaringExecutable(), i);
        }
        throw new AssertionError((Object)"Can't happen");
    }

    public static MethodParameter createMethodParameter(Executable executable, int i) {
        MethodParameter methodParameter;
        if (executable instanceof Method) {
            methodParameter = new MethodParameter((Method)executable, i);
        } else if (executable instanceof Constructor) {
            methodParameter = new MethodParameter((Constructor)executable, i);
        } else {
            throw new IllegalArgumentException("Unsupported Executable: " + executable);
        }
        methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
        return methodParameter;
    }

    public static Stream<MethodParameter> createMethodParameters(Executable executable) {
        return IntStream.range(0, executable.getParameterCount()).mapToObj(i -> Utils.createMethodParameter(executable, i));
    }
}

