/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jline.utils.Signals;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.shell.Availability;
import org.springframework.shell.CommandNotCurrentlyAvailable;
import org.springframework.shell.CommandNotFound;
import org.springframework.shell.CommandRegistry;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.ConfigurableCommandRegistry;
import org.springframework.shell.ExitRequest;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.MethodTarget;
import org.springframework.shell.MethodTargetRegistrar;
import org.springframework.shell.ParameterResolver;
import org.springframework.shell.ParameterResolverMissingException;
import org.springframework.shell.ParameterValidationException;
import org.springframework.shell.ResultHandler;
import org.springframework.shell.Utils;
import org.springframework.util.ReflectionUtils;

public class Shell
implements CommandRegistry {
    private final ResultHandler resultHandler;
    public static final Object NO_INPUT = new Object();
    @Autowired
    protected ApplicationContext applicationContext;
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    protected Map<String, MethodTarget> methodTargets = new HashMap<String, MethodTarget>();
    protected List<ParameterResolver> parameterResolvers;
    protected static final Object UNRESOLVED = new Object();

    public Shell(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    @Autowired(required=false)
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    @Override
    public Map<String, MethodTarget> listCommands() {
        return this.methodTargets;
    }

    @PostConstruct
    public void gatherMethodTargets() throws Exception {
        ConfigurableCommandRegistry registry = new ConfigurableCommandRegistry();
        for (MethodTargetRegistrar resolver : this.applicationContext.getBeansOfType(MethodTargetRegistrar.class).values()) {
            resolver.register(registry);
        }
        this.methodTargets = registry.listCommands();
        this.methodTargets.values().forEach(this::validateParameterResolvers);
    }

    @Autowired
    public void setParameterResolvers(List<ParameterResolver> resolvers) {
        this.parameterResolvers = new ArrayList<ParameterResolver>(resolvers);
        AnnotationAwareOrderComparator.sort(this.parameterResolvers);
    }

    public void run(InputProvider inputProvider) throws IOException {
        Object result = null;
        while (!(result instanceof ExitRequest)) {
            Input input;
            try {
                input = inputProvider.readInput();
            }
            catch (Exception e) {
                if (e instanceof ExitRequest) break;
                this.resultHandler.handleResult(e);
                continue;
            }
            if (input == null) break;
            result = this.evaluate(input);
            if (result == NO_INPUT || result instanceof ExitRequest) continue;
            this.resultHandler.handleResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Input input) {
        if (this.noInput(input)) {
            return NO_INPUT;
        }
        String line = input.words().stream().collect(Collectors.joining(" ")).trim();
        String command = this.findLongestCommand(line);
        List<String> words = input.words();
        if (command != null) {
            MethodTarget methodTarget = this.methodTargets.get(command);
            Availability availability = methodTarget.getAvailability();
            if (availability.isAvailable()) {
                List<String> wordsForArgs = this.wordsForArguments(command, words);
                Method method = methodTarget.getMethod();
                Thread commandThread = Thread.currentThread();
                Object sh = Signals.register((String)"INT", () -> commandThread.interrupt());
                try {
                    Object[] args = this.resolveArgs(method, wordsForArgs);
                    this.validateArgs(args, methodTarget);
                    Object object = ReflectionUtils.invokeMethod((Method)method, (Object)methodTarget.getBean(), (Object[])args);
                    return object;
                }
                catch (UndeclaredThrowableException e) {
                    if (e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException) {
                        Thread.interrupted();
                    }
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                catch (Exception e) {
                    Exception exception = e;
                    return exception;
                }
                finally {
                    Signals.unregister((String)"INT", (Object)sh);
                }
            }
            return new CommandNotCurrentlyAvailable(command, availability);
        }
        return new CommandNotFound(words);
    }

    private boolean noInput(Input input) {
        return input.words().isEmpty() || input.words().size() == 1 && input.words().get(0).trim().isEmpty() || input.words().iterator().next().matches("\\s*//.*");
    }

    private List<String> wordsForArguments(String command, List<String> words) {
        int wordsUsedForCommandKey = command.split(" ").length;
        List<String> args = words.subList(wordsUsedForCommandKey, words.size());
        int last = args.size() - 1;
        if (last >= 0 && "".equals(args.get(last))) {
            args.remove(last);
        }
        return args;
    }

    public List<CompletionProposal> complete(CompletionContext context) {
        String prefix = context.upToCursor();
        ArrayList<CompletionProposal> candidates = new ArrayList<CompletionProposal>();
        candidates.addAll(this.commandsStartingWith(prefix));
        String best = this.findLongestCommand(prefix);
        if (best != null) {
            CompletionContext argsContext = context.drop(best.split(" ").length);
            MethodTarget methodTarget = this.methodTargets.get(best);
            Method method = methodTarget.getMethod();
            List parameters = Utils.createMethodParameters(method).collect(Collectors.toList());
            for (ParameterResolver resolver : this.parameterResolvers) {
                for (int index = 0; index < parameters.size(); ++index) {
                    MethodParameter parameter = (MethodParameter)parameters.get(index);
                    if (!resolver.supports(parameter)) continue;
                    resolver.complete(parameter, argsContext).stream().forEach(candidates::add);
                }
            }
        }
        return candidates;
    }

    private List<CompletionProposal> commandsStartingWith(String prefix) {
        int lastWordStart = prefix.lastIndexOf(32) + 1;
        return this.methodTargets.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).map(e -> this.toCommandProposal(((String)e.getKey()).substring(lastWordStart), (MethodTarget)e.getValue())).collect(Collectors.toList());
    }

    private CompletionProposal toCommandProposal(String command, MethodTarget methodTarget) {
        return new CompletionProposal(command).dontQuote(true).category("Available commands").description(methodTarget.getHelp());
    }

    private void validateArgs(Object[] args, MethodTarget methodTarget) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != UNRESOLVED) continue;
            MethodParameter methodParameter = Utils.createMethodParameter(methodTarget.getMethod(), i);
            throw new IllegalStateException("Could not resolve " + methodParameter);
        }
        Set constraintViolations = this.validator.forExecutables().validateParameters(methodTarget.getBean(), methodTarget.getMethod(), args, new Class[0]);
        if (constraintViolations.size() > 0) {
            throw new ParameterValidationException(constraintViolations, methodTarget);
        }
    }

    private Object[] resolveArgs(Method method, List<String> wordsForArgs) {
        List parameters = Utils.createMethodParameters(method).collect(Collectors.toList());
        Object[] args = new Object[parameters.size()];
        Arrays.fill(args, UNRESOLVED);
        for (ParameterResolver resolver : this.parameterResolvers) {
            for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                MethodParameter parameter = (MethodParameter)parameters.get(argIndex);
                if (args[argIndex] != UNRESOLVED || !resolver.supports(parameter)) continue;
                args[argIndex] = resolver.resolve(parameter, wordsForArgs).resolvedValue();
            }
        }
        return args;
    }

    private void validateParameterResolvers(MethodTarget methodTarget) {
        Utils.createMethodParameters(methodTarget.getMethod()).forEach(parameter -> this.parameterResolvers.stream().filter(resolver -> resolver.supports((MethodParameter)parameter)).findFirst().orElseThrow(() -> new ParameterResolverMissingException((MethodParameter)parameter)));
    }

    private String findLongestCommand(String prefix) {
        String result = this.methodTargets.keySet().stream().filter(command -> prefix.equals(command) || prefix.startsWith(command + " ")).reduce("", (c1, c2) -> c1.length() > c2.length() ? c1 : c2);
        return "".equals(result) ? null : result;
    }
}

