/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CompletionContext {
    private final List<String> words;
    private final int wordIndex;
    private final int position;

    public CompletionContext(List<String> words, int wordIndex, int position) {
        this.words = words;
        this.wordIndex = wordIndex;
        this.position = position;
    }

    public List<String> getWords() {
        return this.words;
    }

    public int getWordIndex() {
        return this.wordIndex;
    }

    public int getPosition() {
        return this.position;
    }

    public String upToCursor() {
        String start = this.words.subList(0, this.wordIndex).stream().collect(Collectors.joining(" "));
        if (this.wordIndex < this.words.size()) {
            if (!start.isEmpty()) {
                start = start + " ";
            }
            start = start + this.currentWord().substring(0, this.position);
        }
        return start;
    }

    public String currentWord() {
        return this.wordIndex >= 0 && this.wordIndex < this.words.size() ? this.words.get(this.wordIndex) : null;
    }

    public String currentWordUpToCursor() {
        String currentWord = this.currentWord();
        return currentWord != null ? currentWord.substring(0, this.getPosition()) : null;
    }

    public CompletionContext drop(int nbWords) {
        return new CompletionContext(new ArrayList<String>(this.words.subList(nbWords, this.words.size())), this.wordIndex - nbWords, this.position);
    }
}

