/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.result;

import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.CommandRegistry;
import org.springframework.shell.jline.InteractiveShellApplicationRunner;
import org.springframework.shell.result.TerminalAwareResultHandler;
import org.springframework.util.StringUtils;

public class ThrowableResultHandler
extends TerminalAwareResultHandler<Throwable> {
    public static final String DETAILS_COMMAND_NAME = "stacktrace";
    private Throwable lastError;
    @Autowired
    @Lazy
    private CommandRegistry commandRegistry;
    @Autowired
    @Lazy
    private InteractiveShellApplicationRunner interactiveRunner;

    @Override
    protected void doHandleResult(Throwable result) {
        this.lastError = result;
        String toPrint = StringUtils.hasLength((String)result.getMessage()) ? result.getMessage() : result.toString();
        this.terminal.writer().println(new AttributedString((CharSequence)toPrint, AttributedStyle.DEFAULT.foreground(1)).toAnsi());
        if (this.interactiveRunner.isEnabled() && this.commandRegistry.listCommands().containsKey(DETAILS_COMMAND_NAME)) {
            this.terminal.writer().println(new AttributedStringBuilder().append((CharSequence)"Details of the error have been omitted. You can use the ", AttributedStyle.DEFAULT.foreground(1)).append((CharSequence)DETAILS_COMMAND_NAME, AttributedStyle.DEFAULT.foreground(1).bold()).append((CharSequence)" command to print the full stacktrace.", AttributedStyle.DEFAULT.foreground(1)).toAnsi());
        }
        this.terminal.writer().flush();
        if (!this.interactiveRunner.isEnabled()) {
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            throw new RuntimeException(result);
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }
}

