/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import org.jline.reader.Parser;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.shell.Shell;
import org.springframework.shell.jline.FileInputProvider;
import org.springframework.shell.jline.InteractiveShellApplicationRunner;

@Order(value=-100)
public class ScriptShellApplicationRunner
implements ApplicationRunner {
    public static final String SPRING_SHELL_SCRIPT = "spring.shell.script";
    public static final String ENABLED = "spring.shell.script";
    public static final String SPRING_SHELL_SCRIPT_ENABLED = "spring.shell.script.spring.shell.script";
    private final Parser parser;
    private final Shell shell;
    private final ConfigurableEnvironment environment;

    public ScriptShellApplicationRunner(Parser parser, Shell shell, ConfigurableEnvironment environment) {
        this.parser = parser;
        this.shell = shell;
        this.environment = environment;
    }

    public void run(ApplicationArguments args) throws Exception {
        List scriptsToRun = args.getNonOptionArgs().stream().filter(s -> s.startsWith("@")).map(s -> new File(s.substring(1))).collect(Collectors.toList());
        boolean batchEnabled = (Boolean)this.environment.getProperty(SPRING_SHELL_SCRIPT_ENABLED, Boolean.TYPE, (Object)true);
        if (!scriptsToRun.isEmpty() && batchEnabled) {
            InteractiveShellApplicationRunner.disable(this.environment);
            for (File file : scriptsToRun) {
                FileReader reader = new FileReader(file);
                Throwable throwable = null;
                try {
                    FileInputProvider inputProvider = new FileInputProvider(reader, this.parser);
                    Throwable throwable2 = null;
                    try {
                        this.shell.run(inputProvider);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputProvider == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputProvider.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputProvider.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
        }
    }
}

