/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.function.Supplier;
import org.springframework.shell.Availability;
import org.springframework.shell.Command;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class MethodTarget
implements Command {
    private final Method method;
    private final Object bean;
    private final Command.Help help;
    private final Supplier<Availability> availabilityIndicator;

    public MethodTarget(Method method, Object bean, String help) {
        this(method, bean, new Command.Help(help, null), null);
    }

    public MethodTarget(Method method, Object bean, String help, Supplier<Availability> availabilityIndicator) {
        this(method, bean, new Command.Help(help, null), availabilityIndicator);
    }

    public MethodTarget(Method method, Object bean, Command.Help help, Supplier<Availability> availabilityIndicator) {
        Assert.notNull((Object)method, (String)"Method cannot be null");
        Assert.notNull((Object)bean, (String)"Bean cannot be null");
        Assert.hasText((String)help.getDescription(), (String)String.format("Help cannot be blank when trying to define command based on '%s'", method));
        ReflectionUtils.makeAccessible((Method)method);
        this.method = method;
        this.bean = bean;
        this.help = help;
        this.availabilityIndicator = availabilityIndicator != null ? availabilityIndicator : () -> Availability.available();
    }

    public static MethodTarget of(String name, Object bean, Command.Help help) {
        return MethodTarget.of(name, bean, help, null);
    }

    public static MethodTarget of(String name, Object bean, Command.Help help, Supplier<Availability> availabilityIndicator) {
        HashSet found = new HashSet();
        ReflectionUtils.doWithMethods(bean.getClass(), found::add, m -> m.getName().equals(name));
        if (found.size() != 1) {
            throw new IllegalArgumentException(String.format("Could not find unique method named '%s' on object of class %s. Found %s", name, bean.getClass(), found));
        }
        return new MethodTarget((Method)found.iterator().next(), bean, help, availabilityIndicator);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getHelp() {
        return this.help.getDescription();
    }

    public String getGroup() {
        return this.help.getGroup();
    }

    public Availability getAvailability() {
        return this.availabilityIndicator.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodTarget that = (MethodTarget)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (!this.bean.equals(that.bean)) {
            return false;
        }
        if (!this.help.equals(that.help)) {
            return false;
        }
        return this.help.equals(that.help);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.bean.hashCode();
        result = 31 * result + this.help.hashCode();
        result = 31 * result + this.help.hashCode();
        return result;
    }

    public String toString() {
        return this.method.toString();
    }
}

