/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.utils;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.AsCodeUser;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Role;
import com.xebialabs.ascode.yaml.model.RolesSpec;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.ascode.yaml.model.UsersSpec;
import com.xebialabs.ascode.yaml.model.permission.PermissionRelation;
import com.xebialabs.ascode.yaml.model.permission.PermissionsSpec;
import com.xebialabs.ascode.yaml.sugar.GenerateStrategy;
import com.xebialabs.ascode.yaml.sugar.SugarDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.ascode.utils.Validator;
import com.xebialabs.xlrelease.ascode.yaml.model.StartReleaseSpec;
import com.xebialabs.xlrelease.ascode.yaml.model.permission.TeamPermissionRelation;
import com.xebialabs.xlrelease.ascode.yaml.model.user.User;
import com.xebialabs.xlrelease.ascode.yaml.sugar.XLRSugar$;
import com.xebialabs.xlrelease.domain.folder.Folder;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Validator$ {
    public static Validator$ MODULE$;
    private final List<Type> acceptedTypes;

    static {
        new Validator$();
    }

    private List<Type> acceptedTypes() {
        return this.acceptedTypes;
    }

    private void checkCorrectness(List<ConfigurationItem> specCi, String kind) {
        List incorrectInstances = (List)specCi.filterNot((Function1 & Serializable & scala.Serializable)ci -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkCorrectness$1(ci)));
        if (incorrectInstances.nonEmpty()) {
            String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following definitions used in the definition are not accepted on the ", " kind: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kind, ((TraversableOnce)incorrectInstances.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getType(), List$.MODULE$.canBuildFrom())).mkString(", ")}));
            throw new AsCodeException(errorMsg, AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private List<Validator.DuplicationHelper> checkCis(List<ConfigurationItem> cis, String parent) {
        List<Validator.DuplicationHelper> folders;
        Tuple2 tuple2 = cis.partition((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkCis$1(x$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List folderCis = (List)tuple2._1();
        List otherCis = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)folderCis, (Object)otherCis);
        Tuple2 tuple23 = tuple22;
        List folderCis2 = (List)tuple23._1();
        List otherCis2 = (List)tuple23._2();
        List<Validator.DuplicationHelper> list = folders = this.checkFolders((List<Folder>)folderCis2, parent);
        return ((List)otherCis2.map((Function1 & Serializable & scala.Serializable)ci -> {
            String title = Utils$.MODULE$.getCiTitle((ConfigurationItem)ci);
            String id = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ci.getType().toString(), Utils$.MODULE$.buildFolderPath(parent, title)}));
            return new Validator.DuplicationHelper(id, (ConfigurationItem)ci);
        }, List$.MODULE$.canBuildFrom())).$colon$colon$colon(list);
    }

    private String checkCis$default$2() {
        return "";
    }

    private List<Validator.DuplicationHelper> checkFolders(List<Folder> folderCis, String parent) {
        return (List)folderCis.flatMap((Function1 & Serializable & scala.Serializable)folder -> {
            String folderId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parent, folder.getTitle()}));
            Tuple2 tuple2 = ImplicitConversions$.MODULE$.set$u0020asScala(folder.getChildren()).toList().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkFolders$2(x$5)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List folderChildren = (List)tuple2._1();
            List otherChildren = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)folderChildren, (Object)otherChildren);
            Tuple2 tuple23 = tuple22;
            List folderChildren2 = (List)tuple23._1();
            List otherChildren2 = (List)tuple23._2();
            String folderPath = Utils$.MODULE$.buildFolderPath(parent, folder.getTitle());
            List<Validator.DuplicationHelper> folderChildrenList = MODULE$.checkFolders((List<Folder>)folderChildren2, folderPath);
            List<Validator.DuplicationHelper> otherChildrenList = MODULE$.checkCis((List<ConfigurationItem>)otherChildren2, folderPath);
            Validator.DuplicationHelper duplicationHelper = new Validator.DuplicationHelper(folderId, (ConfigurationItem)folder);
            List<Validator.DuplicationHelper> list = otherChildrenList;
            return folderChildrenList.$colon$colon$colon(list).$colon$colon((Object)duplicationHelper);
        }, List$.MODULE$.canBuildFrom());
    }

    private void checkDupe(List<ConfigurationItem> specCi, String kind) {
        List<Validator.DuplicationHelper> processedCis = this.checkCis(specCi, this.checkCis$default$2());
        List cisList = (List)processedCis.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.id(), List$.MODULE$.canBuildFrom());
        List duplicatedCis = com.xebialabs.ascode.utils.Utils$.MODULE$.getDuplicatedObjects(cisList);
        if (duplicatedCis.nonEmpty()) {
            Map filteredCis = ((TraversableOnce)((List)processedCis.filter((Function1 & Serializable & scala.Serializable)processedCi -> BoxesRunTime.boxToBoolean((boolean)duplicatedCis.contains((Object)processedCi.id())))).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.id()), (Object)x.ci()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            String errorMessage = ((TraversableOnce)filteredCis.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String id = (String)tuple2._1();
                ConfigurationItem ci = (ConfigurationItem)tuple2._2();
                String[] splittedCi = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])id.split("-"))).tail();
                String ciType = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splittedCi)).head();
                String title = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splittedCi)).tail())).mkString();
                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The path [", "] with title [", "] is not unique. All ", " titles in the template must be unique."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ciType, title, ci.getType().toString()}));
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void checkStartReleaseFields(StartReleaseSpec startReleaseSpec) {
        boolean filteredReleases;
        boolean bl = filteredReleases = startReleaseSpec.releaseName().startsWith("/") || startReleaseSpec.templatePath().startsWith("/");
        if (filteredReleases) {
            String wrongField = startReleaseSpec.templatePath().startsWith("/") ? startReleaseSpec.templatePath() : startReleaseSpec.releaseName();
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The current definition is not valid. Some of the paths got an '/' at the beginning. The paths are: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{wrongField})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void checkPermissionsFields(PermissionsSpec permissionsSpec) {
        List directoriesWithInvalidCharacters = (List)permissionsSpec.permissions().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            TeamPermissionRelation teamPermissionRelation;
            PermissionRelation permissionRelation = x0$3;
            Iterable iterable = permissionRelation instanceof TeamPermissionRelation && (teamPermissionRelation = (TeamPermissionRelation)permissionRelation).directory().startsWith("/") ? Option$.MODULE$.option2Iterable((Option)new Some((Object)teamPermissionRelation.directory())) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, List$.MODULE$.canBuildFrom());
        if (directoriesWithInvalidCharacters.nonEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The current definition is not valid. Some of the paths got an '/' at the beginning. The paths are: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directoriesWithInvalidCharacters.mkString(", ")})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void checkRolesFields(RolesSpec rolesSpec) {
        rolesSpec.roles().foreach((Function1 & Serializable & scala.Serializable)role -> {
            Validator$.$anonfun$checkRolesFields$1(role);
            return BoxedUnit.UNIT;
        });
    }

    public void checkUsersFields(UsersSpec usersSpec) {
        usersSpec.users().foreach((Function1 & Serializable & scala.Serializable)usr -> {
            Validator$.$anonfun$checkUsersFields$1(usr);
            return BoxedUnit.UNIT;
        });
    }

    public void validateDefinition(Definition definition) {
        Spec spec = definition.spec();
        if (spec instanceof CiSpec) {
            CiSpec ciSpec = (CiSpec)spec;
            this.checkCorrectness((List<ConfigurationItem>)ciSpec.cis(), definition.kind());
            this.checkDupe((List<ConfigurationItem>)ciSpec.cis(), definition.kind());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (spec instanceof StartReleaseSpec) {
            StartReleaseSpec startReleaseSpec = (StartReleaseSpec)spec;
            this.checkStartReleaseFields(startReleaseSpec);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (spec instanceof PermissionsSpec) {
            PermissionsSpec permissionsSpec = (PermissionsSpec)spec;
            this.checkPermissionsFields(permissionsSpec);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (spec instanceof RolesSpec) {
            RolesSpec rolesSpec = (RolesSpec)spec;
            this.checkRolesFields(rolesSpec);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (spec instanceof UsersSpec) {
            UsersSpec usersSpec = (UsersSpec)spec;
            this.checkUsersFields(usersSpec);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)spec);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkCorrectness$1(ConfigurationItem ci) {
        Type type = ci.getType();
        return MODULE$.acceptedTypes().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCis$1(ConfigurationItem x$2) {
        return x$2 instanceof Folder;
    }

    public static final /* synthetic */ boolean $anonfun$checkFolders$2(ConfigurationItem x$5) {
        return x$5 instanceof Folder;
    }

    public static final /* synthetic */ void $anonfun$checkRolesFields$1(Role role) {
        if (role.name() == null || role.name().isEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The current definition is not valid. Some of the names are empty. All the roles must have a name."})).s((Seq)Nil$.MODULE$), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final /* synthetic */ void $anonfun$checkUsersFields$1(AsCodeUser usr) {
        User user = (User)usr;
        if (user.username() == null || user.username().isEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The current definition is not valid. Some of the usernames are empty. All the users must have a username."})).s((Seq)Nil$.MODULE$), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (user.password() == null || user.password().isEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The current definition is not valid. Some of the passwords are empty. All the users must have a password."})).s((Seq)Nil$.MODULE$), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private Validator$() {
        MODULE$ = this;
        this.acceptedTypes = ((TraversableOnce)XLRSugar$.MODULE$.config().typeToDescriptors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Type ciType = (Type)tuple2._1();
            SugarDescriptor sugarDescriptor = (SugarDescriptor)tuple2._2();
            GenerateStrategy generateStrategy = sugarDescriptor.generateHints().strategy();
            GenerateStrategy.Reject$ reject$ = GenerateStrategy.Reject$.MODULE$;
            if (generateStrategy == null) {
                if (reject$ == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)ciType));
            } else if (generateStrategy.equals(reject$)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)ciType));
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }
}

