/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.utils;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.utils.TypeSugar$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.ascode.utils.Validator;
import com.xebialabs.xlrelease.ascode.yaml.model.StartReleaseSpec;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Validator$ {
    public static Validator$ MODULE$;
    private final List<Type> acceptedTypes;

    static {
        new Validator$();
    }

    private List<Type> acceptedTypes() {
        return this.acceptedTypes;
    }

    private void checkCorrectness(List<ConfigurationItem> specCi, String kind) {
        String string = kind;
        if (!"Templates".equals(string)) {
            throw new MatchError((Object)string);
        }
        List list = (List)specCi.filterNot((Function1 & Serializable & scala.Serializable)ci -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkCorrectness$1(ci)));
        List incorrectInstances = list;
        if (incorrectInstances.nonEmpty()) {
            String errorMsg = new StringBuilder(80).append("The following definitions used in the definition are not accepted on the ").append(kind).append(" kind: ").append(((TraversableOnce)incorrectInstances.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getType(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString();
            throw new AsCodeException(errorMsg, AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private List<Validator.DuplicationHelper> checkCis(List<ConfigurationItem> cis, String parent) {
        List<Validator.DuplicationHelper> folders;
        Tuple2 tuple2 = cis.partition((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkCis$1(x$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List folderCis = (List)tuple2._1();
        List otherCis = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)folderCis, (Object)otherCis);
        Tuple2 tuple23 = tuple22;
        List folderCis2 = (List)tuple23._1();
        List otherCis2 = (List)tuple23._2();
        List<Validator.DuplicationHelper> list = folders = this.checkFolders((List<Folder>)folderCis2, parent);
        return ((List)otherCis2.map((Function1 & Serializable & scala.Serializable)ci -> {
            String title = Utils$.MODULE$.getCiTitle((ConfigurationItem)ci);
            String id = new StringBuilder(1).append(ci.getType().toString()).append("-").append(Utils$.MODULE$.buildFolderPath(parent, title)).toString();
            return new Validator.DuplicationHelper(id, (ConfigurationItem)ci);
        }, List$.MODULE$.canBuildFrom())).$colon$colon$colon(list);
    }

    private String checkCis$default$2() {
        return "";
    }

    private List<Validator.DuplicationHelper> checkFolders(List<Folder> folderCis, String parent) {
        return (List)folderCis.flatMap((Function1 & Serializable & scala.Serializable)folder -> {
            String folderId = new StringBuilder(8).append("Folder-").append(parent).append("-").append(folder.getTitle()).toString();
            Tuple2 tuple2 = ImplicitConversions$.MODULE$.set$u0020asScala(folder.getChildren()).toList().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkFolders$2(x$5)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List folderChildren = (List)tuple2._1();
            List otherChildren = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)folderChildren, (Object)otherChildren);
            Tuple2 tuple23 = tuple22;
            List folderChildren2 = (List)tuple23._1();
            List otherChildren2 = (List)tuple23._2();
            String folderPath = Utils$.MODULE$.buildFolderPath(parent, folder.getTitle());
            List<Validator.DuplicationHelper> folderChildrenList = MODULE$.checkFolders((List<Folder>)folderChildren2, folderPath);
            List<Validator.DuplicationHelper> otherChildrenList = MODULE$.checkCis((List<ConfigurationItem>)otherChildren2, folderPath);
            Validator.DuplicationHelper duplicationHelper = new Validator.DuplicationHelper(folderId, (ConfigurationItem)folder);
            List<Validator.DuplicationHelper> list = otherChildrenList;
            return folderChildrenList.$colon$colon$colon(list).$colon$colon((Object)duplicationHelper);
        }, List$.MODULE$.canBuildFrom());
    }

    private void checkDupe(List<ConfigurationItem> specCi, String kind) {
        List<Validator.DuplicationHelper> processedCis = this.checkCis(specCi, this.checkCis$default$2());
        List cisList = (List)processedCis.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.id(), List$.MODULE$.canBuildFrom());
        List duplicatedCis = com.xebialabs.ascode.utils.Utils$.MODULE$.getDuplicatedObjects(cisList);
        if (duplicatedCis.nonEmpty()) {
            Map filteredCis = ((TraversableOnce)((List)processedCis.filter((Function1 & Serializable & scala.Serializable)processedCi -> BoxesRunTime.boxToBoolean((boolean)duplicatedCis.contains((Object)processedCi.id())))).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.id()), (Object)x.ci()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            String errorMessage = ((TraversableOnce)filteredCis.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String id = (String)tuple2._1();
                ConfigurationItem ci = (ConfigurationItem)tuple2._2();
                String[] splittedCi = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])id.split("-"))).tail();
                String ciType = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splittedCi)).head();
                String title = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splittedCi)).tail())).mkString();
                String string = new StringBuilder(84).append("The path [").append(ciType).append("] with title [").append(title).append("] is not unique. All ").append(ci.getType().toString()).append(" titles in the template must be unique.").toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            throw new AsCodeException(String.valueOf(errorMessage), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void checkStartReleaseFields(StartReleaseSpec startReleaseSpec) {
        boolean filteredReleases;
        boolean bl = filteredReleases = startReleaseSpec.releaseName().startsWith("/") || startReleaseSpec.templatePath().startsWith("/");
        if (filteredReleases) {
            String wrongField = startReleaseSpec.templatePath().startsWith("/") ? startReleaseSpec.templatePath() : startReleaseSpec.releaseName();
            throw new AsCodeException(new StringBuilder(101).append("The current definition is not valid. Some of the paths got an '/' at the beginning. The paths are: [").append(wrongField).append("]").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void validateDefinition(Definition definition) {
        Spec spec = definition.spec();
        if (spec instanceof CiSpec) {
            CiSpec ciSpec = (CiSpec)spec;
            this.checkCorrectness((List<ConfigurationItem>)ciSpec.cis(), definition.kind());
            this.checkDupe((List<ConfigurationItem>)ciSpec.cis(), definition.kind());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (spec instanceof StartReleaseSpec) {
            StartReleaseSpec startReleaseSpec = (StartReleaseSpec)spec;
            this.checkStartReleaseFields(startReleaseSpec);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)spec);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkCorrectness$1(ConfigurationItem ci) {
        Type type = ci.getType();
        return MODULE$.acceptedTypes().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCis$1(ConfigurationItem x$2) {
        return x$2 instanceof Folder;
    }

    public static final /* synthetic */ boolean $anonfun$checkFolders$2(ConfigurationItem x$5) {
        return x$5 instanceof Folder;
    }

    private Validator$() {
        MODULE$ = this;
        this.acceptedTypes = new .colon.colon((Object)TypeSugar$.MODULE$.typeOf(ClassTag$.MODULE$.apply(Release.class)), (List)new .colon.colon((Object)TypeSugar$.MODULE$.typeOf(ClassTag$.MODULE$.apply(Folder.class)), (List)new .colon.colon((Object)TypeSugar$.MODULE$.typeOf(ClassTag$.MODULE$.apply(Configuration.class)), (List)new .colon.colon((Object)TypeSugar$.MODULE$.typeOf(ClassTag$.MODULE$.apply(Dashboard.class)), (List)new .colon.colon((Object)TypeSugar$.MODULE$.typeOf(ClassTag$.MODULE$.apply(Variable.class)), (List)Nil$.MODULE$)))));
    }
}

