/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.stress.runner;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import com.xebialabs.xlrelease.stress.ReportingAPI;
import com.xebialabs.xlrelease.stress.Scenario;
import com.xebialabs.xlrelease.stress.api.control.Flow;
import com.xebialabs.xlrelease.stress.api.log.Logging;
import com.xebialabs.xlrelease.stress.config.GrafanaConfig;
import com.xebialabs.xlrelease.stress.domain.HttpSession;
import com.xebialabs.xlrelease.stress.domain.Phase$;
import com.xebialabs.xlrelease.stress.domain.Release$;
import com.xebialabs.xlrelease.stress.domain.Task$;
import com.xebialabs.xlrelease.stress.domain.User;
import com.xebialabs.xlrelease.stress.runner.Runner$;
import com.xebialabs.xlrelease.stress.utils.ZipUtils$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Runner$ {
    public static final Runner$ MODULE$ = new Runner$();

    public IO<BoxedUnit> runIO(Scenario scenario, FiniteDuration setupTimeout, FiniteDuration programTimeout, ReportingAPI report) {
        Timer timer = IO$.MODULE$.timer(scenario.api().ec());
        ContextShift cs = IO$.MODULE$.contextShift(scenario.api().ec());
        DateTime startTime = DateTime.now();
        User reportUser = new User(report.reportingXlrConfig().xlrConfig().username(), "", "", report.reportingXlrConfig().xlrConfig().password());
        IO setup = ((Logging)((Object)report.log())).info((Function0<String>)(Function0 & Serializable)() -> "Clearing old admin credentials", scenario.self()).flatMap((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            IO iO = scenario.api().xlr().users().clearCookies(scenario.self()).flatMap((Function1 & Serializable)x$5 -> {
                BoxedUnit boxedUnit = x$5;
                IO iO = ((Logging)((Object)report.log())).info((Function0<String>)(Function0 & Serializable)() -> "setting up...", scenario.self()).flatMap((Function1 & Serializable)x$4 -> {
                    BoxedUnit boxedUnit = x$4;
                    IO iO = ((Flow)((Object)report.control())).time(scenario.setup()).flatMap((Function1 & Serializable)timedParams -> ((Logging)((Object)report.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("setup complete: ").append(implicits$.MODULE$.toShow(timedParams._2(), scenario.showParams()).show()).append(" in ").append(((FiniteDuration)timedParams._1()).toMillis()).append("ms").toString(), scenario.self()).map((Function1 & Serializable)x$3 -> {
                        BoxedUnit boxedUnit = x$3;
                        Object object = timedParams._2();
                        return object;
                    }));
                    return iO;
                });
                return iO;
            });
            return iO;
        });
        IO runSetup = this.timeoutTo(setup, setupTimeout, ((Logging)((Object)report.log())).warn((Function0<String>)(Function0 & Serializable)() -> "Setup timed out before completion", scenario.self()).map((Function1 & Serializable)x$25 -> {
            CancellationException error = new CancellationException("setup timed out before completion");
            return new Tuple2(x$25, (Object)error);
        }).flatMap((Function1 & Serializable)x$27 -> {
            Tuple2 tuple2 = x$27;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CancellationException error = (CancellationException)tuple2._2();
            IO iO = Runner$.closeTask$1((Option)new Some((Object)error), report, reportUser, scenario, cs, startTime).flatMap((Function1 & Serializable)x$26 -> {
                BoxedUnit boxedUnit = x$26;
                IO iO = IO$.MODULE$.raiseError((Throwable)error).map((Function1 & Serializable)e -> e);
                return iO;
            });
            return iO;
        }), (Timer<IO>)timer, (ContextShift<IO>)cs);
        return (IO)FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(implicits$.MODULE$.catsSyntaxApplicativeError((Object)this.runScenario$1(runSetup, cs, programTimeout, report, scenario, timer, startTime, reportUser), (ApplicativeError)IO$.MODULE$.ioConcurrentEffect(cs)), (PartialFunction)new Serializable(report, scenario){
            private static final long serialVersionUID = 0L;
            private final ReportingAPI report$1;
            private final Scenario scenario$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                IO<BoxedUnit> iO = ((Logging)((Object)this.report$1.log())).warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Error while executing program: ").append(A1.toString()).append(" ").append(A1.getMessage()).toString(), this.scenario$1.self());
                return (B1)iO;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.report$1 = report$1;
                this.scenario$1 = scenario$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.lang.Throwable )}, serializedLambda);
            }
        }, (ApplicativeError)IO$.MODULE$.ioConcurrentEffect(cs)), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs)), (Function0 & Serializable)() -> scenario.api().metric().clear(), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs));
    }

    public Future<BoxedUnit> runFuture(Scenario scenario, FiniteDuration setupTimeout, FiniteDuration programTimeout, ReportingAPI report) {
        return this.runIO(scenario, setupTimeout, programTimeout, report).unsafeToFuture();
    }

    public <A> IO<A> timeoutTo(IO<A> p, FiniteDuration after, IO<A> fallback, Timer<IO> timer, ContextShift<IO> cs) {
        return (IO)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps((Object)IO$.MODULE$.race(p, (IO)timer.sleep(after), cs), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs)), (Function1 & Serializable)x0$1 -> {
            IO iO;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Object a = left.value();
                iO = (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId(a), (Applicative)IO$.MODULE$.ioConcurrentEffect(cs));
            } else if (either instanceof Right) {
                iO = fallback;
            } else {
                throw new MatchError((Object)either);
            }
            return iO;
        }, (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs));
    }

    public static final /* synthetic */ void $anonfun$runIO$4(BoxedUnit x$1) {
        BoxedUnit boxedUnit = x$1;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final IO com$xebialabs$xlrelease$stress$runner$Runner$$error$1(String msg, Throwable e, ReportingAPI report$1, Scenario scenario$1) {
        return ((Logging)((Object)report$1.log())).error((Function0<String>)(Function0 & Serializable)() -> msg, scenario$1.self()).flatMap((Function1 & Serializable)x$2 -> {
            IO<BoxedUnit> iO;
            BoxedUnit boxedUnit = x$2;
            Option option = Option$.MODULE$.apply((Object)e);
            if (None$.MODULE$.equals(option)) {
                iO = report$1.control().nop();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Throwable err = (Throwable)some.value();
                StackTraceElement[] stackTrace = err.getStackTrace();
                iO = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])stackTrace)) ? ((Logging)((Object)report$1.log())).error((Function0<String>)(Function0 & Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])stackTrace).mkString("Stack trace:\n", "\n", ""), scenario$1.self()) : report$1.control().nop();
            } else {
                throw new MatchError((Object)option);
            }
            IO iO2 = iO.map((Function1 & Serializable)x$1 -> {
                Runner$.$anonfun$runIO$4(x$1);
                return BoxedUnit.UNIT;
            });
            return iO2;
        });
    }

    private static final Throwable error$default$2$1() {
        return null;
    }

    public static final /* synthetic */ void $anonfun$runIO$19(BoxedUnit x$7) {
        BoxedUnit boxedUnit = x$7;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    private static final IO flushMetrics$1(ReportingAPI report$1, Scenario scenario$1, ContextShift cs$1, DateTime startTime$1, User reportUser$1) {
        return ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> "Flushing metrics...", scenario$1.self()).flatMap((Function1 & Serializable)x$10 -> {
            BoxedUnit boxedUnit = x$10;
            IO iO = report$1.metricFlusher().flush(report$1.reportingXlrConfig().taskId(), scenario$1.self()).flatMap((Function1 & Serializable)x$9 -> {
                BoxedUnit boxedUnit = x$9;
                IO iO = ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> "Metrics flushed.", scenario$1.self()).flatMap((Function1 & Serializable)x$8 -> {
                    BoxedUnit boxedUnit = x$8;
                    IO iO = (report$1.reportingXlrConfig().grafanaConfig().server().enabled() ? FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps((Object)Runner$.fetchGraphs$1(report$1, scenario$1, startTime$1), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (Function1 & Serializable)files -> Runner$.uploadGraphs$1(files, report$1, scenario$1, reportUser$1, cs$1), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)) : report$1.control().nop()).map((Function1 & Serializable)x$7 -> {
                        Runner$.$anonfun$runIO$19(x$7);
                        return BoxedUnit.UNIT;
                    });
                    return iO;
                });
                return iO;
            });
            return iO;
        });
    }

    private static final IO fetchGraphs$1(ReportingAPI report$1, Scenario scenario$1, DateTime startTime$1) {
        DateTime endTime = DateTime.now();
        return ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> "Fetching grafana graphs...", scenario$1.self()).flatMap((Function1 & Serializable)x$15 -> {
            BoxedUnit boxedUnit = x$15;
            GrafanaConfig.DashboardsConfig dashboardsConfig = report$1.reportingXlrConfig().grafanaConfig().dashboards();
            IO iO = ((Flow)((Object)report$1.control())).concurrently(8, report$1.reportingXlrConfig().grafanaConfig().panels().toList().flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                GrafanaConfig.DashboardConfig dashboard = (GrafanaConfig.DashboardConfig)tuple2._1();
                Set panels = (Set)tuple2._2();
                Set set = (Set)panels.map((Function1 & Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dashboard), x$11));
                return set;
            }).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                GrafanaConfig.DashboardConfig dashboard = (GrafanaConfig.DashboardConfig)tuple2._1();
                GrafanaConfig.PanelConfig panel = (GrafanaConfig.PanelConfig)tuple2._2();
                IO iO = report$1.grafana().fetchGraph(dashboard, panel, startTime$1, endTime, scenario$1.self(), dashboardsConfig).flatMap((Function1 & Serializable)file -> ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Downloaded ").append(dashboard.name()).append("/").append(panel.name()).append(" chart: ").append(file.getAbsoluteFile().toString()).toString(), scenario$1.self()).map((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    File file = file;
                    return file;
                }));
                return iO;
            })).map((Function1 & Serializable)x$13 -> (List)x$13.flatten(Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable)files -> ((Logging)((Object)scenario$1.api().log())).info((Function0<String>)(Function0 & Serializable)() -> "Downloaded all grafana graphs, creating zip archive.", scenario$1.self()).map((Function1 & Serializable)x$14 -> {
                BoxedUnit boxedUnit = x$14;
                List list = files;
                return list;
            }));
            return iO;
        });
    }

    public static final /* synthetic */ void $anonfun$runIO$37(BoxedUnit x$16) {
        BoxedUnit boxedUnit = x$16;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$runIO$38(BoxedUnit x$17) {
        BoxedUnit boxedUnit = x$17;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    private static final IO uploadGraphs$1(Seq files, ReportingAPI report$1, Scenario scenario$1, User reportUser$1, ContextShift cs$1) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            Path downloadDir = report$1.reportingXlrConfig().grafanaConfig().server().downloadDir().toAbsolutePath();
            Path parentDir = downloadDir.getParent();
            return ZipUtils$.MODULE$.archive((Seq<File>)files, parentDir.resolve(new StringBuilder(11).append(scenario$1.name()).append("-graphs.zip").toString()).toFile(), (Option<String>)new Some((Object)((Object)downloadDir).toString()));
        }).flatMap((Function1 & Serializable)archive -> ((IO)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(report$1.xlr().users().login(reportUser$1, scenario$1.self()), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (Function1 & Serializable)session -> report$1.xlr().tasks().addAttachment(report$1.reportingXlrConfig().taskId(), (File)archive, (HttpSession)session, scenario$1.self()).flatMap((Function1 & Serializable)id -> ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Uploaded attachment '").append((String)id).append("'").toString(), scenario$1.self()).map((Function1 & Serializable)x$16 -> {
            Runner$.$anonfun$runIO$37(x$16);
            return BoxedUnit.UNIT;
        })), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1))).map((Function1 & Serializable)x$17 -> {
            Runner$.$anonfun$runIO$38(x$17);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$runIO$44(BoxedUnit x$19) {
        BoxedUnit boxedUnit = x$19;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    private static final IO program$1(Object params, ReportingAPI report$1, Scenario scenario$1) {
        return ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> "Running scenario", scenario$1.self()).flatMap((Function1 & Serializable)x$20 -> {
            BoxedUnit boxedUnit = x$20;
            IO iO = ((Flow)((Object)report$1.control())).time(scenario$1.program(params)).map((Function1 & Serializable)x$18 -> (FiniteDuration)x$18._1()).flatMap((Function1 & Serializable)time -> ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Scenario done in ").append(time.toMillis()).append("ms").toString(), scenario$1.self()).map((Function1 & Serializable)x$19 -> {
                Runner$.$anonfun$runIO$44(x$19);
                return BoxedUnit.UNIT;
            }));
            return iO;
        });
    }

    public static final /* synthetic */ void $anonfun$runIO$49(BoxedUnit x$21) {
        BoxedUnit boxedUnit = x$21;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ IO $anonfun$runIO$47(ReportingAPI report$1, Scenario scenario$1, boolean x$22) {
        boolean bl = x$22;
        IO iO = ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("Failed task '").append(implicits$.MODULE$.toShow((Object)report$1.reportingXlrConfig().taskId(), Task$.MODULE$.showTaskId(Phase$.MODULE$.showPhaseId(Release$.MODULE$.showReleaseId()))).show()).append("'").toString(), scenario$1.self()).map((Function1 & Serializable)x$21 -> {
            Runner$.$anonfun$runIO$49(x$21);
            return BoxedUnit.UNIT;
        });
        return iO;
    }

    public static final /* synthetic */ void $anonfun$runIO$54(BoxedUnit x$23) {
        BoxedUnit boxedUnit = x$23;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ IO $anonfun$runIO$52(ReportingAPI report$1, Scenario scenario$1, boolean x$24) {
        boolean bl = x$24;
        IO iO = ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Task '").append(implicits$.MODULE$.toShow((Object)report$1.reportingXlrConfig().taskId(), Task$.MODULE$.showTaskId(Phase$.MODULE$.showPhaseId(Release$.MODULE$.showReleaseId()))).show()).append("' completed").toString(), scenario$1.self()).map((Function1 & Serializable)x$23 -> {
            Runner$.$anonfun$runIO$54(x$23);
            return BoxedUnit.UNIT;
        });
        return iO;
    }

    private static final IO closeTask$1(Option error, ReportingAPI report$1, User reportUser$1, Scenario scenario$1, ContextShift cs$1, DateTime startTime$1) {
        return (IO)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(report$1.xlr().users().login(reportUser$1, scenario$1.self()), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (Function1 & Serializable)session -> (IO)error.map((Function1 & Serializable)err -> report$1.xlr().tasks().fail(report$1.reportingXlrConfig().taskId(), new StringBuilder(17).append("Scenario failed: ").append(err.getMessage()).toString(), (HttpSession)session, scenario$1.self()).flatMap((Function1 & Serializable)x$22 -> Runner$.$anonfun$runIO$47(report$1, scenario$1, BoxesRunTime.unboxToBoolean((Object)x$22)))).getOrElse((Function0 & Serializable)() -> ((Flow)((Object)report$1.control())).now().flatMap((Function1 & Serializable)now -> report$1.xlr().tasks().complete(report$1.reportingXlrConfig().taskId(), (Option<String>)new Some((Object)new StringBuilder(24).append("Scenario completed in ").append(now.getMillis() - startTime$1.getMillis()).append("ms").toString()), (HttpSession)session, scenario$1.self()).flatMap((Function1 & Serializable)x$24 -> Runner$.$anonfun$runIO$52(report$1, scenario$1, BoxesRunTime.unboxToBoolean((Object)x$24))))), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1));
    }

    public static final /* synthetic */ void $anonfun$runIO$66(BoxedUnit x$29) {
        BoxedUnit boxedUnit = x$29;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final IO com$xebialabs$xlrelease$stress$runner$Runner$$runCleanup$1(Object params, Option error, ReportingAPI report$1, Scenario scenario$1, User reportUser$1, ContextShift cs$1, DateTime startTime$1) {
        return ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> "Cleaning up...", scenario$1.self()).flatMap((Function1 & Serializable)x$31 -> {
            BoxedUnit boxedUnit = x$31;
            IO iO = ((Flow)((Object)report$1.control())).time(scenario$1.cleanup(params)).map((Function1 & Serializable)x$28 -> (FiniteDuration)x$28._1()).flatMap((Function1 & Serializable)time -> ((Logging)((Object)report$1.log())).info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("cleanup complete in ").append(time.toMillis()).append("ms").toString(), scenario$1.self()).flatMap((Function1 & Serializable)x$30 -> {
                BoxedUnit boxedUnit = x$30;
                IO iO = Runner$.closeTask$1(error, report$1, reportUser$1, scenario$1, cs$1, startTime$1).map((Function1 & Serializable)x$29 -> {
                    Runner$.$anonfun$runIO$66(x$29);
                    return BoxedUnit.UNIT;
                });
                return iO;
            }));
            return iO;
        });
    }

    private static final Option runCleanup$default$2$1() {
        return None$.MODULE$;
    }

    private static final IO runProgram$1(Object params, ContextShift cs$1, ReportingAPI report$1, Scenario scenario$1, DateTime startTime$1, User reportUser$1) {
        return (IO)ApplicativeErrorOps$.MODULE$.recoverWith$extension(implicits$.MODULE$.catsSyntaxApplicativeError(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps((Object)Runner$.program$1(params, report$1, scenario$1), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (Function0 & Serializable)() -> Runner$.flushMetrics$1(report$1, scenario$1, cs$1, startTime$1, reportUser$1), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (Function0 & Serializable)() -> Runner$.com$xebialabs$xlrelease$stress$runner$Runner$$runCleanup$1(params, Runner$.runCleanup$default$2$1(), report$1, scenario$1, reportUser$1, cs$1, startTime$1), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (ApplicativeError)IO$.MODULE$.ioConcurrentEffect(cs$1)), (PartialFunction)new Serializable(params, report$1, scenario$1, reportUser$1, cs$1, startTime$1){
            private static final long serialVersionUID = 0L;
            private final Object params$3;
            private final ReportingAPI report$1;
            private final Scenario scenario$1;
            private final User reportUser$1;
            private final ContextShift cs$1;
            private final DateTime startTime$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                IO iO = Runner$.com$xebialabs$xlrelease$stress$runner$Runner$$error$1(new StringBuilder(31).append("Error while executing program: ").append(A1.toString()).toString(), A1, this.report$1, this.scenario$1).flatMap((Function1 & Serializable)x$34 -> {
                    BoxedUnit boxedUnit = x$34;
                    IO iO = Runner$.com$xebialabs$xlrelease$stress$runner$Runner$$runCleanup$1($this.params$3, (Option)new Some((Object)A1), $this.report$1, $this.scenario$1, $this.reportUser$1, $this.cs$1, $this.startTime$1).flatMap((Function1 & Serializable)x$33 -> {
                        BoxedUnit boxedUnit = x$33;
                        IO iO = $this.report$1.control().error((Function0<Throwable>)(Function0 & Serializable)() -> A1).map((Function1 & Serializable)x$32 -> {
                            anonfun.runProgram.1.1.$anonfun$applyOrElse$4(x$32);
                            return BoxedUnit.UNIT;
                        });
                        return iO;
                    });
                    return iO;
                });
                return (B1)iO;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$4(Nothing$ x$32) {
                Nothing$ nothing$ = x$32;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.params$3 = params$3;
                this.report$1 = report$1;
                this.scenario$1 = scenario$1;
                this.reportUser$1 = reportUser$1;
                this.cs$1 = cs$1;
                this.startTime$1 = startTime$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.stress.runner.Runner$$anonfun$runProgram$1$1 java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$2(com.xebialabs.xlrelease.stress.runner.Runner$$anonfun$runProgram$1$1 java.lang.Throwable scala.runtime.BoxedUnit ), $anonfun$applyOrElse$3(java.lang.Throwable ), $anonfun$applyOrElse$4$adapted(scala.runtime.Nothing$ )}, serializedLambda);
            }
        }, (ApplicativeError)IO$.MODULE$.ioConcurrentEffect(cs$1));
    }

    public static final /* synthetic */ void $anonfun$runIO$73(Nothing$ x$35) {
        Nothing$ nothing$ = x$35;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final IO runProgramAndCleanup$1(Object params, FiniteDuration programTimeout$1, ReportingAPI report$1, Scenario scenario$1, Timer timer$1, ContextShift cs$1, DateTime startTime$1, User reportUser$1) {
        return this.timeoutTo(Runner$.runProgram$1(params, cs$1, report$1, scenario$1, startTime$1, reportUser$1), programTimeout$1, ((Logging)((Object)report$1.log())).warn((Function0<String>)(Function0 & Serializable)() -> "Program timed out, running cleanup", scenario$1.self()).flatMap((Function1 & Serializable)x$37 -> {
            BoxedUnit boxedUnit = x$37;
            IO iO = Runner$.com$xebialabs$xlrelease$stress$runner$Runner$$runCleanup$1(params, Runner$.runCleanup$default$2$1(), report$1, scenario$1, reportUser$1, cs$1, startTime$1).flatMap((Function1 & Serializable)x$36 -> {
                BoxedUnit boxedUnit = x$36;
                IO iO = report$1.control().fail((Function0<String>)(Function0 & Serializable)() -> "Program timed out").map((Function1 & Serializable)x$35 -> {
                    Runner$.$anonfun$runIO$73(x$35);
                    return BoxedUnit.UNIT;
                });
                return iO;
            });
            return iO;
        }), (Timer<IO>)timer$1, (ContextShift<IO>)cs$1);
    }

    private final IO runScenario$1(IO runSetup$1, ContextShift cs$1, FiniteDuration programTimeout$1, ReportingAPI report$1, Scenario scenario$1, Timer timer$1, DateTime startTime$1, User reportUser$1) {
        return (IO)FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps((Object)runSetup$1, (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1)), (Function1 & Serializable)params -> this.runProgramAndCleanup$1(params, programTimeout$1, report$1, scenario$1, timer$1, cs$1, startTime$1, reportUser$1), (FlatMap)IO$.MODULE$.ioConcurrentEffect(cs$1));
    }

    private Runner$() {
    }
}

