/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.stress.api.metric;

import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.headers.Authorization;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.OAuth2BearerToken;
import akka.stream.Graph;
import akka.stream.IOResult;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import com.xebialabs.xlrelease.stress.Scenario;
import com.xebialabs.xlrelease.stress.api.control.Control;
import com.xebialabs.xlrelease.stress.api.http.Client;
import com.xebialabs.xlrelease.stress.api.json.JsonParser;
import com.xebialabs.xlrelease.stress.api.log.Logging;
import com.xebialabs.xlrelease.stress.config.GrafanaConfig;
import com.xebialabs.xlrelease.stress.utils.IOHelpers$;
import com.xebialabs.xlrelease.stress.utils.IOHelpers$FutureToIO$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t[\u0001\u0011\t\u0011)A\u0006]!A1\u0007\u0001B\u0001B\u0003-A\u0007\u0003\u0005@\u0001\t\u0005\t\u0015a\u0003A\u0011!)\u0005A!A!\u0002\u00171\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b1\u0002'\t\u0011I\u0003!\u0011!Q\u0001\fMC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006Y\u0001\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003O\u0002A\u0011CA5\u0011\u001d\tY\t\u0001C\t\u0003\u001b\u0013Qb\u0012:bM\u0006t\u0017m\u00117jK:$(BA\b\u0011\u0003\u0019iW\r\u001e:jG*\u0011\u0011CE\u0001\u0004CBL'BA\n\u0015\u0003\u0019\u0019HO]3tg*\u0011QCF\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0006\r\u0002\u0013a,'-[1mC\n\u001c(\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0007tKJ4XM]\"p]\u001aLw\r\u0005\u0002%U9\u0011Q\u0005K\u0007\u0002M)\u0011qEE\u0001\u0007G>tg-[4\n\u0005%2\u0013!D$sC\u001a\fg.Y\"p]\u001aLw-\u0003\u0002,Y\ta1+\u001a:wKJ\u001cuN\u001c4jO*\u0011\u0011FJ\u0001\bG>tGO]8m!\ty\u0013'D\u00011\u0015\ti\u0003#\u0003\u00023a\t91i\u001c8ue>d\u0017\u0001\u00025uiB\u00142!N\u001c=\r\u00111\u0004\u0001\u0001\u001b\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005aRT\"A\u001d\u000b\u0005M\u0002\u0012BA\u001e:\u0005\u0019\u0019E.[3oiB\u0011\u0001(P\u0005\u0003}e\u0012qaU3tg&|g.A\u0002m_\u001e\u0004\"!Q\"\u000e\u0003\tS!a\u0010\t\n\u0005\u0011\u0013%a\u0002'pO\u001eLgnZ\u0001\u0005UN|g\u000e\u0005\u0002H\u00136\t\u0001J\u0003\u0002F!%\u0011!\n\u0013\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\u0018AA3d!\ti\u0005+D\u0001O\u0015\tye$\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0015(\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!A7\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016AB:ue\u0016\fWNC\u0001Y\u0003\u0011\t7n[1\n\u0005i+&\u0001D'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AA2t!\ri&\rZ\u0007\u0002=*\u0011q\fY\u0001\u0007K\u001a4Wm\u0019;\u000b\u0003\u0005\fAaY1ug&\u00111M\u0018\u0002\r\u0007>tG/\u001a=u'\"Lg\r\u001e\t\u0003;\u0016L!A\u001a0\u0003\u0005%{\u0015A\u0002\u001fj]&$h\b\u0006\u0002jkRA!\u000e\\7qcJ\u001cH\u000f\u0005\u0002l\u00015\ta\u0002C\u0003.\u0013\u0001\u000fa\u0006C\u00034\u0013\u0001\u000faNE\u0002poq2AA\u000e\u0001\u0001]\")q(\u0003a\u0002\u0001\")Q)\u0003a\u0002\r\")1*\u0003a\u0002\u0019\")!+\u0003a\u0002'\")1,\u0003a\u00029\")!%\u0003a\u0001G\u0005Qa-\u001a;dQ\u001e\u0013\u0018\r\u001d5\u0015\u0013a\f9$!\u0011\u0002L\u0005\rD#B=\u0002\u0006\u0005E\u0001cA/fuB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0005%|'\"A@\u0002\t)\fg/Y\u0005\u0004\u0003\u0007a(\u0001\u0002$jY\u0016Dq!a\u0002\u000b\u0001\b\tI!\u0001\u0005tG\u0016t\u0017M]5p!\u0011\tY!!\u0004\u000e\u0003II1!a\u0004\u0013\u0005!\u00196-\u001a8be&|\u0007bBA\n\u0015\u0001\u000f\u0011QC\u0001\u0011I\u0006\u001c\bNY8be\u0012\u001c8i\u001c8gS\u001e\u0004B!a\u0006\u000249\u0019\u0011\u0011\u0004\u0015\u000f\t\u0005m\u0011\u0011\u0007\b\u0005\u0003;\tyC\u0004\u0003\u0002 \u00055b\u0002BA\u0011\u0003WqA!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OQ\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0002$\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0003OII1!!\u000e-\u0005A!\u0015m\u001d5c_\u0006\u0014Hm]\"p]\u001aLw\rC\u0004\u0002:)\u0001\r!a\u000f\u0002\u0013\u0011\f7\u000f\u001b2pCJ$\u0007\u0003BA\f\u0003{I1!a\u0010-\u0005=!\u0015m\u001d5c_\u0006\u0014HmQ8oM&<\u0007bBA\"\u0015\u0001\u0007\u0011QI\u0001\u0006a\u0006tW\r\u001c\t\u0005\u0003/\t9%C\u0002\u0002J1\u00121\u0002U1oK2\u001cuN\u001c4jO\"9\u0011Q\n\u0006A\u0002\u0005=\u0013\u0001\u00024s_6\u0004B!!\u0015\u0002`5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003uS6,'\u0002BA-\u00037\nAA[8eC*\u0011\u0011QL\u0001\u0004_J<\u0017\u0002BA1\u0003'\u0012\u0001\u0002R1uKRKW.\u001a\u0005\b\u0003KR\u0001\u0019AA(\u0003\t!x.\u0001\u0003qCRDG\u0003BA6\u0003\u0013#B!!\u001c\u0002\bB!\u0011qNAA\u001d\u0011\t\t(! \u000e\u0005\u0005M$\u0002BA;\u0003o\nQ!\\8eK2TA!!\u001f\u0002|\u0005A1oY1mC\u0012\u001cHN\u0003\u00024/&!\u0011qPA:\u0003\r)&/[\u0005\u0005\u0003\u0007\u000b)I\u0001\u0003QCRD'\u0002BA@\u0003gBq!a\u0005\f\u0001\b\t)\u0002C\u0004\u0002:-\u0001\r!a\u000f\u0002\u000bE,XM]=\u0015\u0011\u0005=\u0015\u0011TAN\u0003;#B!!%\u0002\u0018B!\u0011qNAJ\u0013\u0011\t)*!\"\u0003\u000bE+XM]=\t\u000f\u0005MA\u0002q\u0001\u0002\u0016!9\u0011\u0011\b\u0007A\u0002\u0005m\u0002bBA\"\u0019\u0001\u0007\u0011Q\t\u0005\b\u0003?c\u0001\u0019AAQ\u0003\u0015\u0011\u0018M\\4f!\u001di\u00121UA(\u0003\u001fJ1!!*\u001f\u0005\u0019!V\u000f\u001d7fe\u0001")
public class GrafanaClient {
    private final GrafanaConfig.ServerConfig serverConfig;
    private final Client http;
    private final Logging log;
    private final Materializer m;
    private final ContextShift<IO> cs;

    public IO<File> fetchGraph(GrafanaConfig.DashboardConfig dashboard, GrafanaConfig.PanelConfig panel, DateTime from, DateTime to, Scenario scenario, GrafanaConfig.DashboardsConfig dashboardsConfig) {
        Uri uri = this.serverConfig.server().withPath(this.path(dashboard, dashboardsConfig)).withQuery(this.query(dashboard, panel, (Tuple2<DateTime, DateTime>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)from), (Object)to), dashboardsConfig));
        return this.log.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("metric.grafana.fetchGraph(").append(dashboard.name()).append(", ").append(panel.name()).append(", ").append(from).append(", ").append(to).append(")").toString(), scenario).flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            IO iO = $this.log.info((Function0<String>)(Function0 & Serializable)() -> uri.toString(), scenario).flatMap((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit = x$3;
                Authorization authorization = new Authorization((HttpCredentials)new OAuth2BearerToken($this.serverConfig.token()));
                IO iO = $this.http.get(uri, (List<HttpHeader>)Nil$.MODULE$.$colon$colon((Object)authorization)).map((Function1 & Serializable)resp -> {
                    String filename = new StringBuilder(5).append(dashboard.name()).append("_").append(panel.name()).append(".png").toString();
                    Path path = $this.serverConfig.downloadDir().resolve(scenario.name()).resolve(filename);
                    return new Tuple3(resp, (Object)filename, (Object)path);
                }).flatMap((Function1 & Serializable)x$2 -> {
                    Tuple3 tuple3 = x$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    HttpResponse resp = (HttpResponse)tuple3._1();
                    Path path = (Path)tuple3._3();
                    IO iO = IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        void var1_1;
                        File f = path.toFile();
                        f.getParentFile().mkdirs();
                        f.createNewFile();
                        return var1_1;
                    }).flatMap((Function1 & Serializable)file -> IOHelpers$FutureToIO$.MODULE$.io$extension(IOHelpers$.MODULE$.FutureToIO((Future)resp.entity().dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(Paths.get(file.getAbsolutePath(), new String[0]), FileIO$.MODULE$.toPath$default$2()), $this.m)), $this.cs).map((Function1 & Serializable)x$1 -> {
                        IOResult iOResult = x$1;
                        File file = file;
                        return file;
                    }));
                    return iO;
                });
                return iO;
            });
            return iO;
        });
    }

    public Uri.Path path(GrafanaConfig.DashboardConfig dashboard, GrafanaConfig.DashboardsConfig dashboardsConfig) {
        return this.serverConfig.rootPath().$div("render").$div("d-solo").$div(dashboard.id()).$div(dashboard.name());
    }

    public Uri.Query query(GrafanaConfig.DashboardConfig dashboard, GrafanaConfig.PanelConfig panel, Tuple2<DateTime, DateTime> range, GrafanaConfig.DashboardsConfig dashboardsConfig) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Duration duration = new Duration((ReadableInstant)range._1(), (ReadableInstant)range._2());
        if (duration.getStandardMinutes() < 5L) {
            Duration diff = Duration.standardMinutes((long)5L).minus((ReadableDuration)duration);
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((DateTime)range._1()).minus((ReadableDuration)diff)), range._2());
        } else {
            tuple22 = tuple2 = range;
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DateTime from = (DateTime)tuple2._1();
        DateTime to = (DateTime)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)from, (Object)to);
        Tuple2 tuple24 = tuple23;
        DateTime from2 = (DateTime)tuple24._1();
        DateTime to2 = (DateTime)tuple24._2();
        Uri.Query base = Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"width"), (Object)((Object)BoxesRunTime.boxToInteger((int)dashboardsConfig.width())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"height"), (Object)((Object)BoxesRunTime.boxToInteger((int)dashboardsConfig.height())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orgId"), (Object)((Object)BoxesRunTime.boxToInteger((int)dashboardsConfig.orgId())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tz"), (Object)dashboardsConfig.timezone()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)((Object)BoxesRunTime.boxToLong((long)from2.getMillis())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)((Object)BoxesRunTime.boxToLong((long)to2.getMillis())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"panelId"), (Object)((Object)BoxesRunTime.boxToInteger((int)panel.id())).toString())}));
        return (Uri.Query)dashboard.parameters().foldLeft((Object)base, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Uri.Query query;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    query = (Uri.Query)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(4).append("var-").append(key).toString()), (Object)value);
            Uri.Query.Cons cons = query.$plus$colon(tuple23);
            return cons;
        });
    }

    public GrafanaClient(GrafanaConfig.ServerConfig serverConfig, Control control, Client http, Logging log, JsonParser json, ExecutionContext ec, Materializer m, ContextShift<IO> cs) {
        this.serverConfig = serverConfig;
        this.http = http;
        this.log = log;
        this.m = m;
        this.cs = cs;
    }
}

