package com.xebialabs.xlrelease.stress.utils

import cats.effect.{ContextShift, IO}
import cats.implicits._
import com.xebialabs.xlrelease.stress.Scenario

import scala.concurrent.Future
import scala.util.{Success, Try}

object IOHelpers {

  implicit class FutureToIO[A](val future: Future[A]) extends AnyVal {
    def io(implicit cs: ContextShift[IO]): IO[A] = IO.fromFuture(IO(future))
  }

  implicit class EitherToIO[E <: Throwable, A](val either: Either[E, A]) extends AnyVal {
    def io: IO[A] = IO.fromEither(either)
  }
}
