package com.xebialabs.xlrelease.stress.utils

import java.io.File

import akka.http.scaladsl.model.ContentTypes.`application/json`
import akka.http.scaladsl.model.MediaTypes.`application/zip`
import akka.http.scaladsl.model.{HttpEntity, Multipart, RequestEntity, Uri}
import akka.stream.Materializer
import akka.stream.scaladsl.Sink
import spray.json._

import scala.concurrent.{ExecutionContext, Future}
import scala.util.Try

object HttpHelpers {

  implicit class IdAsUriPath(val _id: String) extends AnyVal {
    def asPath: Uri.Path = {
      val elements = _id.split("[/-]").toList
      elements.tail.foldLeft[Uri.Path](Uri.Path / elements.head) {
        case (l, r) => l / r
      }
    }
  }

  implicit class JsonToHttpEntity(val json: JsValue) extends AnyVal {
    def toHttpEntity: RequestEntity = HttpEntity(`application/json`, json.compactPrint)
  }

  implicit class PlayJsonToHttpEntity(val json: play.api.libs.json.JsValue) extends AnyVal {
    def toHttpEntity: RequestEntity = HttpEntity(`application/json`, json.toString())
  }

  object MultipartZip {
    def apply(file: File) =
      Multipart.FormData(
        Multipart.FormData.BodyPart.fromFile(name = "file", `application/zip`, file)
      )
  }

  implicit class EntityOps(val entity: HttpEntity) extends AnyVal {

    def asString(implicit m: Materializer, ex: ExecutionContext): Future[String] =
      entity.dataBytes
        .map(_.utf8String)
        .runWith(Sink.seq)
        .map(_.mkString(""))

    def asJson(implicit m: Materializer, ec: ExecutionContext): Future[JsValue] =
      for {
        content <- asString
        result <- Future.fromTry(Try(content.parseJson))
      } yield result
  }

}
