package com.xebialabs.xlrelease.stress.utils

import akka.actor.ActorSystem
import akka.http.scaladsl.Http
import akka.http.scaladsl.model.HttpMethods._
import akka.http.scaladsl.model._
import akka.stream.ActorMaterializer
import com.xebialabs.xlrelease.stress.config.defaults.http.client.{headers => defaultHeaders}
import org.slf4j.LoggerFactory

import scala.concurrent.{ExecutionContext, Future}
import scala.language.postfixOps

class AkkaHttpClient {

  private[this] val logger = LoggerFactory.getLogger("HTTP")

  implicit val system: ActorSystem = ActorSystem()
  implicit val materializer: ActorMaterializer = ActorMaterializer()
  implicit val ec: ExecutionContext = system.dispatcher

  def get(uri: Uri, headers: List[HttpHeader] = defaultHeaders): Future[HttpResponse] =
    request(HttpRequest(GET, uri, headers))

  def post(uri: Uri, entity: RequestEntity, headers: List[HttpHeader] = defaultHeaders): Future[HttpResponse] =
    request(HttpRequest(POST, uri, headers, entity))

  def put(uri: Uri, entity: RequestEntity, headers: List[HttpHeader] = defaultHeaders): Future[HttpResponse] =
    request(HttpRequest(PUT, uri, headers, entity))

  def delete(uri: Uri, headers: List[HttpHeader] = defaultHeaders): Future[HttpResponse] =
    request(HttpRequest(DELETE, uri, headers))

  def request(req: HttpRequest): Future[HttpResponse] =
    Http().singleRequest(req).map { resp =>
      logger.debug(req.method.value + " " + req.uri.toString + ": " + resp.status.toString)
      resp
    }

  def shutdown(): Future[Unit] =
    Http().shutdownAllConnectionPools()

}
