package com.xebialabs.xlrelease.stress.handlers

import cats.effect.IO
import com.xebialabs.xlrelease.stress.api
import org.slf4j.{Logger, LoggerFactory}

class LoggingHandler extends api.log.Raw with api.log.Logging with api.log.Session {

  private[this] val log: Logger = LoggerFactory.getLogger("API")

  override def logError(msg: => String): IO[Unit] = IO(log.error(msg))

  override def logWarn(msg: => String): IO[Unit] = IO(log.warn(msg))

  override def logInfo(msg: => String): IO[Unit] = IO(log.info(msg))

  override def logDebug(msg: => String): IO[Unit] = IO(log.debug(msg))

}
