package com.xebialabs.xlrelease.stress.handlers

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import akka.http.scaladsl.model.HttpResponse
import cats.effect.{ContextShift, IO}
import com.xebialabs.xlrelease.stress.api
import com.xebialabs.xlrelease.stress.utils.AkkaHttpClient
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.EntityOps
import com.xebialabs.xlrelease.stress.utils.IOHelpers.FutureToIO
import spray.json._

import scala.util.Try

class JsonHandler(akkaHttp: AkkaHttpClient)(implicit cs: ContextShift[IO]) extends api.json.JsonParser with SprayJsonSupport {
  import akkaHttp.{ec, materializer}

  override def parse(resp: HttpResponse): IO[JsValue] = resp.entity.asJson.io

}
