package com.xebialabs.xlrelease.stress.handlers

import akka.http.scaladsl.model._
import cats.effect.{ContextShift, IO}
import cats.implicits._
import com.xebialabs.xlrelease.stress.api
import com.xebialabs.xlrelease.stress.utils.AkkaHttpClient
import com.xebialabs.xlrelease.stress.utils.IOHelpers.FutureToIO

class HttpHandler(akkaHttp: AkkaHttpClient)(implicit cs: ContextShift[IO]) extends api.http.Client with api.http.Session {
  import akkaHttp.materializer

  override def get(uri: Uri, headers: List[HttpHeader]): IO[HttpResponse] =
    akkaHttp.get(uri, headers).io

  override def post(uri: Uri, entity: RequestEntity, headers: List[HttpHeader]): IO[HttpResponse] =
    akkaHttp.post(uri, entity, headers).io

  override def put(uri: Uri, entity: RequestEntity, headers: List[HttpHeader]): IO[HttpResponse] =
    akkaHttp.put(uri, entity, headers).io

  override def delete(uri: Uri, headers: List[HttpHeader]): IO[HttpResponse] =
    akkaHttp.delete(uri, headers).io

  override def discard(resp: HttpResponse): IO[Unit] = {
    resp.discardEntityBytes()
    ().pure[IO]
  }
}
