package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath

case class Transition(name: String)

object Transition {
  case class ID(id: String)

  implicit val showTransitionId: Show[Transition.ID] = { case ID(id) => id }

  implicit class TransitionIDOps(val id: Transition.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
  }
}
