package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath

case class TrackedItem(name: String)

object TrackedItem {
  case class ID(id: String)

  implicit val showTrackedItemId: Show[TrackedItem.ID] = { case ID(id) => id }

  implicit class TrackedItemIDOps(val id: TrackedItem.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
  }
}