package com.xebialabs.xlrelease.stress.domain

import java.io.File

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath


case class Template(name: String, xlrTemplate: File)

object Template {
  case class ID(id: String)

  implicit val showTemplateId: Show[Template.ID] = { case ID(id) => id }

  implicit class TemplateIDOps(val id: Template.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
  }
}
