package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath

case class Stage(name: String)

object Stage {
  case class ID(id: String)

  implicit val showStageId: Show[Stage.ID] = { case ID(id) => id }

  implicit class StageIDOps(val id: Stage.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
    def patternId: Pattern.ID = Pattern.ID(id.id.split("/").init.mkString("/"))
  }
}


