package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath

object Phase {
  case class ID(release: Release.ID, phase: String)

  implicit def showPhaseId(implicit sr: Show[Release.ID]): Show[Phase.ID] = {
    case ID(releaseId, phaseId) => s"${sr.show(releaseId)}/$phaseId"
  }

  implicit class PhaseIDOps(val id: Phase.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
  }

}