package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats.Show
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath

case class Pattern(name: String)

object Pattern {
  case class ID(id: String)

  implicit val showPatternId: Show[Pattern.ID] = { case ID(id) => id }

  implicit class PatternIDOps(val id: Pattern.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
  }
}
