package com.xebialabs.xlrelease.stress.domain

import akka.http.scaladsl.model.Uri
import cats._
import cats.implicits._
import com.xebialabs.xlrelease.stress.utils.HttpHelpers.IdAsUriPath


case class Folder(name: String, parent: Option[Folder] = None, id: Folder.ID = null)

object Folder {

  case class ID(id: String)

  implicit val showFolderId: Show[Folder.ID] = {
    case ID(id) => id
  }

  implicit val showFolder: Show[Folder] = {
    case Folder(name, parent, id) =>
      parent.map(showFolder.show).getOrElse("") + s"/$name[${id.show}]"
  }

  implicit class FolderIDOps(val id: Folder.ID) extends AnyVal {
    def path: Uri.Path = id.show.asPath
  }

}
